﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/srepo/srepo_Types.h>
#include <nn/srepo/detail/ipc/srepo_IpcService.h>
#include <nn/os.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/util/util_LockGuard.h>

namespace nn { namespace srepo { namespace detail {

/*!
    @brief      シムライブラリのグローバルインスタンスです。

    @details
                シムライブラリのファイル間共通データを管理します。
*/
class ShimLibraryGlobal
{
private:
    /*!
        @brief      コンストラクタです。
    */
    ShimLibraryGlobal() NN_NOEXCEPT :
        m_Session(nullptr)
    {
    }

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static ShimLibraryGlobal& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(ShimLibraryGlobal, s_Instance);
        return s_Instance;
    }

    /*!
        @brief      API 呼び出し用のセッションを取得します。

        @return     セッション。
    */
    detail::ipc::ISrepoService* GetSession() NN_NOEXCEPT
    {
        NN_UTIL_LOCK_GUARD(m_Mutex);

        if (m_Session == nullptr)
        {
            detail::ipc::Initialize();
            m_Session = detail::ipc::GetSrepoService();
            NN_SDK_ASSERT_NOT_NULL(m_Session);
        }

        return m_Session;
    }

private:
    //
    nn::os::SdkMutex m_Mutex;
    //
    detail::ipc::ISrepoService* m_Session;
};

}}}
