﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/srepo/srepo_Types.h>
#include <nn/srepo/detail/srepo_TypesDetail.h>

namespace nn { namespace srepo { namespace detail {

/*!
    @brief      イベント ID を検証します。

    @param[out] outLength   イベント ID の文字列長。
    @param[in]  eventId     イベント ID。

    @return     イベント ID が正しいかどうか。
*/
bool VerifyEventId(size_t* outLength, const char* eventId) NN_NOEXCEPT;

/*!
    @brief      キーを検証します。

    @param[out] outLength   キーの文字列長。
    @param[in]  key         キー。

    @return     キーが正しいかどうか。
*/
bool VerifyKey(size_t* outLength, const char* key) NN_NOEXCEPT;

/*!
    @brief      キーを検証します。

    @param[in]  key         キー。
    @param[in]  length      キーの文字列長。

    @return     キーが正しいかどうか。
*/
bool VerifyKey(const char* key, size_t length) NN_NOEXCEPT;

/*!
    @brief      文字列値を検証します。

    @param[out] outLength   文字列値の文字列長。
    @param[in]  value       文字列値。

    @return     文字列値が正しいかどうか。
*/
bool VerifyStringValue(size_t* outLength, const char* value) NN_NOEXCEPT;

/*!
    @brief      文字列値を検証します。

    @param[in]  value       文字列値。
    @param[in]  length      文字列値の文字列長。

    @return     文字列値が正しいかどうか。
*/
bool VerifyStringValue(const char* value, size_t length) NN_NOEXCEPT;

/*!
    @brief      バイナリ列を検証します。

    @param[in]  value       バイナリ。
    @param[in]  size        バイナリのサイズ。

    @return     バイナリが正しいかどうか。
*/
bool VerifyBinaryValue(const void* value, size_t size) NN_NOEXCEPT;

/*!
    @brief      レポートデータを検証します。

    @param[in]  data        データ。
    @param[in]  dataSize    データサイズ。

    @return     レポートデータが正しいかどうか。
*/
bool VerifyReport(const Bit8* data, size_t dataSize) NN_NOEXCEPT;

/*!
    @brief      レポートデータの保存処理の Result をハンドリングします。

    @param[in]  result  保存処理の結果。

    @return     ハンドルした結果。

    @details
                アプリケーションがハンドリングすべきでないエラーを成功扱いにします。

                保存頻度が高すぎて保存処理が追いつかなかった場合、警告ログを出力します。
*/
nn::Result HandleSaveResult(nn::Result result) NN_NOEXCEPT;

}}}
