﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/srepo/detail/ipc/srepo_ISrepoService.sfdl.h>

namespace nn { namespace srepo { namespace detail { namespace service {

/*!
    @brief      システムレポートサービスです。
*/
class SrepoServiceForGeneric
{
public:
    /*!
        @brief      コンストラクタです。
    */
    SrepoServiceForGeneric() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~SrepoServiceForGeneric() NN_NOEXCEPT;

public:
    // ISrepoService
    nn::Result SaveReport(const nn::sf::InArray<char>& eventId, nn::ApplicationId appId, const nn::sf::InBuffer& data) NN_NOEXCEPT;
    nn::Result SaveReportWithUser(const nn::account::Uid& uid, const nn::sf::InArray<char>& eventId, nn::ApplicationId appId, const nn::sf::InBuffer& data) NN_NOEXCEPT;
    nn::Result SaveReportForAntiPiracy(const nn::sf::InArray<char>& eventId, nn::ApplicationId appId, const nn::sf::InBuffer& data) NN_NOEXCEPT;
    nn::Result SaveReportWithUserForAntiPiracy(const nn::account::Uid& uid, const nn::sf::InArray<char>& eventId, nn::ApplicationId appId, const nn::sf::InBuffer& data) NN_NOEXCEPT;
    nn::Result PopReport(nn::sf::Out<std::int32_t> outCategory, nn::sf::Out<nn::account::Uid> outUid, const nn::sf::OutArray<char>& outEventId, nn::sf::Out<nn::ApplicationId> outAppId, nn::sf::Out<std::int64_t> outDataSize, const nn::sf::OutBuffer& outData) NN_NOEXCEPT;
    nn::Result GetPushEventReadableHandle(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;

    // for account
    nn::Result NotifyUserList(const nn::sf::InArray<nn::account::Uid>& userList) NN_NOEXCEPT;
    nn::Result NotifyUserDeleted(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result NotifyUserRegistered(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result NotifyUserClosed(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result NotifyUserOpened(const nn::account::Uid& uid) NN_NOEXCEPT;
    // for nifm
    nn::Result NotifyCompletedNetworkRequestChanged(int8_t type) NN_NOEXCEPT;
    // for friends
    nn::Result NotifyFriendPresenceChanged(const nn::account::Uid& uid, int8_t state) NN_NOEXCEPT;
    // for npns
    nn::Result NotifyNotificationConnectivityChanged(int8_t state) NN_NOEXCEPT;
    // for omm
    nn::Result NotifyDeviceOperationModeChanged(int8_t mode) NN_NOEXCEPT;
    // for spsm
    nn::Result NotifySystemPowerStateChanged(int8_t state) NN_NOEXCEPT;
    // for am
    nn::Result NotifyForegroundProgramChanged(const nn::ncm::ProgramId& id) NN_NOEXCEPT;
    // for controller
    nn::Result NotifyControllerCountChanged(int8_t wired, int8_t wireless) NN_NOEXCEPT;

};

}}}}
