﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/psc/util/psc_Util.h>

namespace nn { namespace spsm { namespace detail {

    const int MaxModuleCount = 128;
    const int MaxDependencyCount = 128;

    struct PscTransition
    {
        nn::psc::util::TransitionInformation transitionInfo;
        nn::psc::util::ModuleTransitionInformation moduleInfoList[MaxModuleCount];
        nn::psc::util::DependencyInformation dependencyInfoList[MaxDependencyCount];
        int moduleCount;
        int dependencyCount;
    };

}}}
