﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      spsm モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_SPSM_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_SPSM_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_SPSM_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_SPSM_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_SPSM_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_SPSM_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(spsm, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_SPSM_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Trace, 0, format, args)
#define NN_DETAIL_SPSM_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Trace, 1, format, args)
#define NN_DETAIL_SPSM_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Trace, 2, format, args)
#define NN_DETAIL_SPSM_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Trace, 3, format, args)

#define NN_DETAIL_SPSM_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Info, 0, format, args)
#define NN_DETAIL_SPSM_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Info, 1, format, args)
#define NN_DETAIL_SPSM_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Info, 2, format, args)
#define NN_DETAIL_SPSM_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Info, 3, format, args)

#define NN_DETAIL_SPSM_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Warn, 0, format, args)
#define NN_DETAIL_SPSM_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Warn, 1, format, args)
#define NN_DETAIL_SPSM_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Warn, 2, format, args)
#define NN_DETAIL_SPSM_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Warn, 3, format, args)

#define NN_DETAIL_SPSM_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Error, 0, format, args)
#define NN_DETAIL_SPSM_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Error, 1, format, args)
#define NN_DETAIL_SPSM_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Error, 2, format, args)
#define NN_DETAIL_SPSM_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Error, 3, format, args)

#define NN_DETAIL_SPSM_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Fatal, 0, format, args)
#define NN_DETAIL_SPSM_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Fatal, 1, format, args)
#define NN_DETAIL_SPSM_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Fatal, 2, format, args)
#define NN_DETAIL_SPSM_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(spsm, Fatal, 3, format, args)

#define NN_DETAIL_SPSM_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Trace, 0, text, length)
#define NN_DETAIL_SPSM_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Trace, 1, text, length)
#define NN_DETAIL_SPSM_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Trace, 2, text, length)
#define NN_DETAIL_SPSM_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Trace, 3, text, length)

#define NN_DETAIL_SPSM_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Info, 0, text, length)
#define NN_DETAIL_SPSM_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Info, 1, text, length)
#define NN_DETAIL_SPSM_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Info, 2, text, length)
#define NN_DETAIL_SPSM_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Info, 3, text, length)

#define NN_DETAIL_SPSM_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Warn, 0, text, length)
#define NN_DETAIL_SPSM_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Warn, 1, text, length)
#define NN_DETAIL_SPSM_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Warn, 2, text, length)
#define NN_DETAIL_SPSM_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Warn, 3, text, length)

#define NN_DETAIL_SPSM_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Error, 0, text, length)
#define NN_DETAIL_SPSM_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Error, 1, text, length)
#define NN_DETAIL_SPSM_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Error, 2, text, length)
#define NN_DETAIL_SPSM_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Error, 3, text, length)

#define NN_DETAIL_SPSM_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Fatal, 0, text, length)
#define NN_DETAIL_SPSM_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Fatal, 1, text, length)
#define NN_DETAIL_SPSM_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Fatal, 2, text, length)
#define NN_DETAIL_SPSM_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(spsm, Fatal, 3, text, length)
