﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       エラーレポートに関する設定 API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Common.h>

namespace nn { namespace settings { namespace system {

//! @name エラーレポート関連設定 API
//! @{

/**
 * @brief       エラーレポートを他社に提供してよいかの許可状態を表す設定値です。
 */
enum ErrorReportSharePermission
{
    ErrorReportSharePermission_NotConfirmed,    //!< 未設定（初期値）
    ErrorReportSharePermission_Granted,         //!< 同意
    ErrorReportSharePermission_Denied,          //!< 非同意
};

/**
 * @brief       エラーレポートを他社に提供してよいかの許可状態を取得します。
 *
 * @return      エラーレポートを他社に提供してよいかの許可状態です。
 */
ErrorReportSharePermission GetErrorReportSharePermission() NN_NOEXCEPT;

/**
 * @brief       エラーレポートを他社に提供してよいかの許可状態を設定します。
 *
 * @param[in]   permission                  許可状態
 */
void SetErrorReportSharePermission(
    ErrorReportSharePermission permission) NN_NOEXCEPT;

//! @}

}}} // nn::settings::system
