﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       キャプチャ設定に関するシステムアプリケーション向け設定 API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Common.h>

namespace nn { namespace settings { namespace system {

/**
 * @brief       撮影した画面写真を保存するストレージを表す列挙型です。
 */
enum PrimaryAlbumStorage
{
    PrimaryAlbumStorage_Nand = 0,   //!< NAND
    PrimaryAlbumStorage_SdCard = 1, //!< SD カード
};

//! @name キャプチャ設定関連 API
//! @{

/**
 * @brief       撮影した画面写真を保存するストレージを取得します。
 *
 * @return      撮影した画面写真を保存するストレージです。
 */
PrimaryAlbumStorage GetPrimaryAlbumStorage() NN_NOEXCEPT;


/**
 * @brief       撮影した画面写真を保存するストレージを設定します。
 *
 * @param[in]   value                       撮影した画面写真を保存するストレージ
 */
void SetPrimaryAlbumStorage(PrimaryAlbumStorage value) NN_NOEXCEPT;

//! @}

}}} // namespace nn::settings::system
