﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       設定マネージャ実装用 API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/fwdbg/settings_SettingsCommon.h>

namespace nn { namespace settings { namespace fwdbg {

/**
 * @brief       設定管理の操作対象を表す列挙型です。
 */
enum SettingsTarget
{
    SettingsTarget_SystemSaveSystem,                //!< システム設定
    SettingsTarget_SystemSaveFirmwareDebug,         //!< FWDBG 設定（セーブ）
    SettingsTarget_SystemSavePrivate,               //!< プライベート設定
    SettingsTarget_SystemSaveDevice,                //!< デバイス設定
    SettingsTarget_SystemSaveApplication,           //!< アプリケーション設定
    SettingsTarget_SystemDataFirmwareDebug = 10,    //!< FWDBG 設定（データ）
    SettingsTarget_SystemDataPlatformConfigration,  //!< プラットフォーム構成
};

/**
 * @brief       設定を読み出します。
 *
 * @param[out]  outBuffer                   読み出し先となるバッファ
 * @param[in]   count                       読み出し先となるバッファのバイト数
 * @param[in]   target                      操作対象
 *
 * @return      読み出したのバイト数です。
 *
 * @pre
 *              - outBuffer != nullptr
 */
size_t ReadSettings(
    ::nn::Bit8 outBuffer[], size_t count, SettingsTarget target) NN_NOEXCEPT;

/**
 * @brief       設定をリセットします。
 *
 * @param[in]   target                      操作対象
 */
void ResetSettings(SettingsTarget target) NN_NOEXCEPT;

}}} // namespace nn::settings::fwdbg
