﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 *  @file
 *  @brief   SSL クライアント認証に関する API の宣言
 */

#pragma once

#include <nn/nn_BitTypes.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/factory/settings_Result.h>

namespace nn { namespace settings { namespace factory {

/**
 * @brief       SSL クライアント秘密鍵を表す構造体です。
 */
struct SslKey
{
    uint32_t size;          //!< SSL クライアント秘密鍵のバイト数
    ::nn::Bit8 data[308];   //!< SSL クライアント秘密鍵
};

/**
 * @brief       SSL クライアント証明書を表す構造体です。
 */
struct SslCertificate
{
    uint32_t size;          //!< SSL クライアント証明書のバイト数
    ::nn::Bit8 data[2048];  //!< SSL クライアント証明書
};

/**
 * @brief       SSL クライアント秘密鍵を取得します。
 *
 * @param[out]  pOutValue                    SSL クライアント秘密鍵を読みだすバッファ
 *
 * @retresult
 * @handleresult{nn::settings::factory::ResultCalibrationDataFileSystemCorrupted}
 * @handleresult{nn::settings::factory::ResultCalibrationDataCrcError}
 * @endretresult
 *
 * @pre
 *              - pOutValue != nullptr
 */
::nn::Result GetSslKey(SslKey* pOutValue) NN_NOEXCEPT;

/**
 * @brief       SSL クライアント証明書を取得します。
 *
 * @param[out]  pOutValue                    SSL クライアント証明書を読みだすバッファ
 *
 * @retresult
 * @handleresult{nn::settings::factory::ResultCalibrationDataFileSystemCorrupted}
 * @handleresult{nn::settings::factory::ResultCalibrationDataCrcError}
 * @handleresult{nn::settings::factory::ResultCalibrationDataShaError}
 * @endretresult
 *
 * @pre
 *              - pOutValue != nullptr
 */
::nn::Result GetSslCertificate(SslCertificate* pOutValue) NN_NOEXCEPT;

}}} // nn::settings::factory
