﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      settings モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_SETTINGS_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(settings, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(settings, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(settings, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(settings, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_SETTINGS_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(settings, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(settings, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(settings, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(settings, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_SETTINGS_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(settings, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(settings, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(settings, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(settings, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_SETTINGS_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(settings, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(settings, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(settings, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(settings, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_SETTINGS_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(settings, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(settings, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(settings, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_SETTINGS_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(settings, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_SETTINGS_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Trace, 0, format, args)
#define NN_DETAIL_SETTINGS_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Trace, 1, format, args)
#define NN_DETAIL_SETTINGS_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Trace, 2, format, args)
#define NN_DETAIL_SETTINGS_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Trace, 3, format, args)

#define NN_DETAIL_SETTINGS_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Info, 0, format, args)
#define NN_DETAIL_SETTINGS_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Info, 1, format, args)
#define NN_DETAIL_SETTINGS_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Info, 2, format, args)
#define NN_DETAIL_SETTINGS_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Info, 3, format, args)

#define NN_DETAIL_SETTINGS_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Warn, 0, format, args)
#define NN_DETAIL_SETTINGS_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Warn, 1, format, args)
#define NN_DETAIL_SETTINGS_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Warn, 2, format, args)
#define NN_DETAIL_SETTINGS_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Warn, 3, format, args)

#define NN_DETAIL_SETTINGS_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Error, 0, format, args)
#define NN_DETAIL_SETTINGS_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Error, 1, format, args)
#define NN_DETAIL_SETTINGS_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Error, 2, format, args)
#define NN_DETAIL_SETTINGS_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Error, 3, format, args)

#define NN_DETAIL_SETTINGS_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Fatal, 0, format, args)
#define NN_DETAIL_SETTINGS_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Fatal, 1, format, args)
#define NN_DETAIL_SETTINGS_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Fatal, 2, format, args)
#define NN_DETAIL_SETTINGS_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(settings, Fatal, 3, format, args)

#define NN_DETAIL_SETTINGS_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(settings, Trace, 0, text, length)
#define NN_DETAIL_SETTINGS_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(settings, Trace, 1, text, length)
#define NN_DETAIL_SETTINGS_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(settings, Trace, 2, text, length)
#define NN_DETAIL_SETTINGS_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(settings, Trace, 3, text, length)

#define NN_DETAIL_SETTINGS_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(settings, Info, 0, text, length)
#define NN_DETAIL_SETTINGS_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(settings, Info, 1, text, length)
#define NN_DETAIL_SETTINGS_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(settings, Info, 2, text, length)
#define NN_DETAIL_SETTINGS_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(settings, Info, 3, text, length)

#define NN_DETAIL_SETTINGS_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(settings, Warn, 0, text, length)
#define NN_DETAIL_SETTINGS_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(settings, Warn, 1, text, length)
#define NN_DETAIL_SETTINGS_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(settings, Warn, 2, text, length)
#define NN_DETAIL_SETTINGS_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(settings, Warn, 3, text, length)

#define NN_DETAIL_SETTINGS_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(settings, Error, 0, text, length)
#define NN_DETAIL_SETTINGS_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(settings, Error, 1, text, length)
#define NN_DETAIL_SETTINGS_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(settings, Error, 2, text, length)
#define NN_DETAIL_SETTINGS_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(settings, Error, 3, text, length)

#define NN_DETAIL_SETTINGS_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(settings, Fatal, 0, text, length)
#define NN_DETAIL_SETTINGS_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(settings, Fatal, 1, text, length)
#define NN_DETAIL_SETTINGS_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(settings, Fatal, 2, text, length)
#define NN_DETAIL_SETTINGS_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(settings, Fatal, 3, text, length)
