﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief PSM ライブラリの本体機能用の型の宣言。
 */

#pragma once

namespace nn { namespace psm {

/**
 * @brief 充電器の種別です。
 */
enum ChargerType
{
    ChargerType_Unconnected,  //!< 充電器が接続されていません。
    ChargerType_EnoughPower,  //!< 充電可能で、本体の動作状況にかかわらず供給電力が十分な充電器が接続されています。
    ChargerType_LowPower,     //!< 充電可能ですが、本体の動作状況によっては供給電力が十分でない充電器が接続されています。
    ChargerType_NotSupported, //!< 充電不可能な充電器が接続されています。
};

}} // namespace nn::psm
