﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <nn/nn_Result.h>
#include <nn/psm/psm_ErrorReportTypes.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace psm { // NOLINT(whitespace/braces)

class IPsmServer;

class IPsmSession;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IPsmServer, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IPsmServer)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryChargePercentage, (::nn::sf::Out<int> batteryCharge))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetChargerType, (::nn::sf::Out<int> chargerType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(EnableBatteryCharging)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DisableBatteryCharging)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsBatteryChargingEnabled, (::nn::sf::Out<bool> isEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(AcquireControllerPowerSupply)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ReleaseControllerPowerSupply)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::psm::IPsmSession>> outSession))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(EnableEnoughPowerChargeEmulation)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DisableEnoughPowerChargeEmulation)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(EnableFastBatteryCharging)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DisableFastBatteryCharging)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryVoltageState, (::nn::sf::Out<int> outBatteryVoltageState))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRawBatteryChargePercentage, (::nn::sf::Out<double> rawBatteryCharge))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsEnoughPowerSupplied, (::nn::sf::Out<bool> isEnoughPowerSupplied))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryAgePercentage, (::nn::sf::Out<double> batteryAge))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryChargeInfoEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryChargeInfoFields, (::nn::sf::Out<::nn::psm::BatteryChargeInfoFields> outBatteryChargeInfoFields))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryChargeCalibratedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IPsmServer)

        ::nn::Result GetBatteryChargePercentage(::nn::sf::Out<int> batteryCharge) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBatteryChargePercentage, (batteryCharge));
        }

        ::nn::Result GetChargerType(::nn::sf::Out<int> chargerType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetChargerType, (chargerType));
        }

        ::nn::Result EnableBatteryCharging() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(EnableBatteryCharging);
        }

        ::nn::Result DisableBatteryCharging() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DisableBatteryCharging);
        }

        ::nn::Result IsBatteryChargingEnabled(::nn::sf::Out<bool> isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsBatteryChargingEnabled, (isEnabled));
        }

        ::nn::Result AcquireControllerPowerSupply() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(AcquireControllerPowerSupply);
        }

        ::nn::Result ReleaseControllerPowerSupply() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ReleaseControllerPowerSupply);
        }

        ::nn::Result OpenSession(::nn::sf::Out<::nn::sf::SharedPointer<::nn::psm::IPsmSession>> outSession) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSession, (outSession));
        }

        ::nn::Result EnableEnoughPowerChargeEmulation() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(EnableEnoughPowerChargeEmulation);
        }

        ::nn::Result DisableEnoughPowerChargeEmulation() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DisableEnoughPowerChargeEmulation);
        }

        ::nn::Result EnableFastBatteryCharging() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(EnableFastBatteryCharging);
        }

        ::nn::Result DisableFastBatteryCharging() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DisableFastBatteryCharging);
        }

        ::nn::Result GetBatteryVoltageState(::nn::sf::Out<int> outBatteryVoltageState) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBatteryVoltageState, (outBatteryVoltageState));
        }

        ::nn::Result GetRawBatteryChargePercentage(::nn::sf::Out<double> rawBatteryCharge) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRawBatteryChargePercentage, (rawBatteryCharge));
        }

        ::nn::Result IsEnoughPowerSupplied(::nn::sf::Out<bool> isEnoughPowerSupplied) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsEnoughPowerSupplied, (isEnoughPowerSupplied));
        }

        ::nn::Result GetBatteryAgePercentage(::nn::sf::Out<double> batteryAge) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBatteryAgePercentage, (batteryAge));
        }

        ::nn::Result GetBatteryChargeInfoEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBatteryChargeInfoEvent, (outHandle));
        }

        ::nn::Result GetBatteryChargeInfoFields(::nn::sf::Out<::nn::psm::BatteryChargeInfoFields> outBatteryChargeInfoFields) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBatteryChargeInfoFields, (outBatteryChargeInfoFields));
        }

        ::nn::Result GetBatteryChargeCalibratedEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBatteryChargeCalibratedEvent, (outHandle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IPsmServer
    {
    public:
        nn::Result GetBatteryChargePercentage(nn::sf::Out<int> batteryCharge) NN_NOEXCEPT;
        nn::Result GetChargerType(nn::sf::Out<int> chargerType) NN_NOEXCEPT;
        nn::Result EnableBatteryCharging() NN_NOEXCEPT;
        nn::Result DisableBatteryCharging() NN_NOEXCEPT;
        nn::Result IsBatteryChargingEnabled(nn::sf::Out<bool> isEnabled) NN_NOEXCEPT;
        nn::Result AcquireControllerPowerSupply() NN_NOEXCEPT;
        nn::Result ReleaseControllerPowerSupply() NN_NOEXCEPT;
        nn::Result OpenSession(nn::sf::Out<nn::sf::SharedPointer<nn::psm::IPsmSession>> outSession) NN_NOEXCEPT;
        nn::Result EnableEnoughPowerChargeEmulation() NN_NOEXCEPT;
        nn::Result DisableEnoughPowerChargeEmulation() NN_NOEXCEPT;
        nn::Result EnableFastBatteryCharging() NN_NOEXCEPT;
        nn::Result DisableFastBatteryCharging() NN_NOEXCEPT;
        nn::Result GetBatteryVoltageState(nn::sf::Out<int> outBatteryVoltageState) NN_NOEXCEPT;
        nn::Result GetRawBatteryChargePercentage(nn::sf::Out<double> rawBatteryCharge) NN_NOEXCEPT;
        nn::Result IsEnoughPowerSupplied(nn::sf::Out<bool> isEnoughPowerSupplied) NN_NOEXCEPT;
        nn::Result GetBatteryAgePercentage(nn::sf::Out<double> batteryAge) NN_NOEXCEPT;
        nn::Result GetBatteryChargeInfoEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
        nn::Result GetBatteryChargeInfoFields(nn::sf::Out<nn::psm::BatteryChargeInfoFields> outBatteryChargeInfoFields) NN_NOEXCEPT;
        nn::Result GetBatteryChargeCalibratedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetBatteryChargePercentage(nn::sf::Out<int> batteryCharge) NN_NOEXCEPT;
    nn::Result GetChargerType(nn::sf::Out<int> chargerType) NN_NOEXCEPT;
    nn::Result EnableBatteryCharging() NN_NOEXCEPT;
    nn::Result DisableBatteryCharging() NN_NOEXCEPT;
    nn::Result IsBatteryChargingEnabled(nn::sf::Out<bool> isEnabled) NN_NOEXCEPT;
    nn::Result AcquireControllerPowerSupply() NN_NOEXCEPT;
    nn::Result ReleaseControllerPowerSupply() NN_NOEXCEPT;
    nn::Result OpenSession(nn::sf::Out<nn::sf::SharedPointer<nn::psm::IPsmSession>> outSession) NN_NOEXCEPT;
    nn::Result EnableEnoughPowerChargeEmulation() NN_NOEXCEPT;
    nn::Result DisableEnoughPowerChargeEmulation() NN_NOEXCEPT;
    nn::Result EnableFastBatteryCharging() NN_NOEXCEPT;
    nn::Result DisableFastBatteryCharging() NN_NOEXCEPT;
    nn::Result GetBatteryVoltageState(nn::sf::Out<int> outBatteryVoltageState) NN_NOEXCEPT;
    nn::Result GetRawBatteryChargePercentage(nn::sf::Out<double> rawBatteryCharge) NN_NOEXCEPT;
    nn::Result IsEnoughPowerSupplied(nn::sf::Out<bool> isEnoughPowerSupplied) NN_NOEXCEPT;
    nn::Result GetBatteryAgePercentage(nn::sf::Out<double> batteryAge) NN_NOEXCEPT;
    nn::Result GetBatteryChargeInfoEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result GetBatteryChargeInfoFields(nn::sf::Out<nn::psm::BatteryChargeInfoFields> outBatteryChargeInfoFields) NN_NOEXCEPT;
    nn::Result GetBatteryChargeCalibratedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::psm::IPsmServer))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryChargePercentage, (::nn::sf::Out<int> batteryCharge))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBatteryChargePercentage, (batteryCharge));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetChargerType, (::nn::sf::Out<int> chargerType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetChargerType, (chargerType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableBatteryCharging)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(EnableBatteryCharging);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableBatteryCharging)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DisableBatteryCharging);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsBatteryChargingEnabled, (::nn::sf::Out<bool> isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsBatteryChargingEnabled, (isEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(AcquireControllerPowerSupply)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(AcquireControllerPowerSupply);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ReleaseControllerPowerSupply)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ReleaseControllerPowerSupply);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::psm::IPsmSession>> outSession))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSession, (outSession));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableEnoughPowerChargeEmulation)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(EnableEnoughPowerChargeEmulation);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableEnoughPowerChargeEmulation)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DisableEnoughPowerChargeEmulation);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableFastBatteryCharging)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(EnableFastBatteryCharging);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableFastBatteryCharging)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DisableFastBatteryCharging);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryVoltageState, (::nn::sf::Out<int> outBatteryVoltageState))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBatteryVoltageState, (outBatteryVoltageState));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRawBatteryChargePercentage, (::nn::sf::Out<double> rawBatteryCharge))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRawBatteryChargePercentage, (rawBatteryCharge));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsEnoughPowerSupplied, (::nn::sf::Out<bool> isEnoughPowerSupplied))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsEnoughPowerSupplied, (isEnoughPowerSupplied));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryAgePercentage, (::nn::sf::Out<double> batteryAge))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBatteryAgePercentage, (batteryAge));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryChargeInfoEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBatteryChargeInfoEvent, (outHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryChargeInfoFields, (::nn::sf::Out<::nn::psm::BatteryChargeInfoFields> outBatteryChargeInfoFields))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBatteryChargeInfoFields, (outBatteryChargeInfoFields));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryChargeCalibratedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBatteryChargeCalibratedEvent, (outHandle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::psm::IPsmServer>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::psm::IPsmServer))

    // nn::Result GetBatteryChargePercentage(nn::sf::Out<int> batteryCharge) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBatteryChargePercentage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(batteryCharge, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (batteryCharge))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(batteryCharge)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBatteryChargePercentage)

    // nn::Result GetChargerType(nn::sf::Out<int> chargerType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetChargerType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(chargerType, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (chargerType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(chargerType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetChargerType)

    // nn::Result EnableBatteryCharging() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableBatteryCharging)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableBatteryCharging)

    // nn::Result DisableBatteryCharging() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableBatteryCharging)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableBatteryCharging)

    // nn::Result IsBatteryChargingEnabled(nn::sf::Out<bool> isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsBatteryChargingEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsBatteryChargingEnabled)

    // nn::Result AcquireControllerPowerSupply() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireControllerPowerSupply)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireControllerPowerSupply)

    // nn::Result ReleaseControllerPowerSupply() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReleaseControllerPowerSupply)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReleaseControllerPowerSupply)

    // nn::Result OpenSession(nn::sf::Out<nn::sf::SharedPointer<nn::psm::IPsmSession>> outSession) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSession)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outSession, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outSession))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSession)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSession)

    // nn::Result EnableEnoughPowerChargeEmulation() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableEnoughPowerChargeEmulation)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableEnoughPowerChargeEmulation)

    // nn::Result DisableEnoughPowerChargeEmulation() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableEnoughPowerChargeEmulation)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableEnoughPowerChargeEmulation)

    // nn::Result EnableFastBatteryCharging() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableFastBatteryCharging)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableFastBatteryCharging)

    // nn::Result DisableFastBatteryCharging() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableFastBatteryCharging)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableFastBatteryCharging)

    // nn::Result GetBatteryVoltageState(nn::sf::Out<int> outBatteryVoltageState) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBatteryVoltageState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outBatteryVoltageState, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outBatteryVoltageState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBatteryVoltageState)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBatteryVoltageState)

    // nn::Result GetRawBatteryChargePercentage(nn::sf::Out<double> rawBatteryCharge) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRawBatteryChargePercentage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(rawBatteryCharge, (double), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (rawBatteryCharge))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rawBatteryCharge)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRawBatteryChargePercentage)

    // nn::Result IsEnoughPowerSupplied(nn::sf::Out<bool> isEnoughPowerSupplied) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsEnoughPowerSupplied)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isEnoughPowerSupplied, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isEnoughPowerSupplied))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnoughPowerSupplied)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsEnoughPowerSupplied)

    // nn::Result GetBatteryAgePercentage(nn::sf::Out<double> batteryAge) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBatteryAgePercentage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(batteryAge, (double), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (batteryAge))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(batteryAge)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBatteryAgePercentage)

    // nn::Result GetBatteryChargeInfoEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBatteryChargeInfoEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBatteryChargeInfoEvent)

    // nn::Result GetBatteryChargeInfoFields(nn::sf::Out<nn::psm::BatteryChargeInfoFields> outBatteryChargeInfoFields) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBatteryChargeInfoFields)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outBatteryChargeInfoFields, (::nn::psm::BatteryChargeInfoFields), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outBatteryChargeInfoFields))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBatteryChargeInfoFields)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBatteryChargeInfoFields)

    // nn::Result GetBatteryChargeCalibratedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBatteryChargeCalibratedEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBatteryChargeCalibratedEvent)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::psm::BatteryChargeInfoFields), 64, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::psm::IPsmServer, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::psm::IPsmServer))

    // nn::Result GetBatteryChargePercentage(nn::sf::Out<int> batteryCharge) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryChargePercentage, (::nn::sf::Out<int> batteryCharge))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBatteryChargePercentage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(batteryCharge)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBatteryChargePercentage)
    }

    // nn::Result GetChargerType(nn::sf::Out<int> chargerType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetChargerType, (::nn::sf::Out<int> chargerType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetChargerType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(chargerType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetChargerType)
    }

    // nn::Result EnableBatteryCharging() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableBatteryCharging)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableBatteryCharging)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableBatteryCharging)
    }

    // nn::Result DisableBatteryCharging() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableBatteryCharging)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableBatteryCharging)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableBatteryCharging)
    }

    // nn::Result IsBatteryChargingEnabled(nn::sf::Out<bool> isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsBatteryChargingEnabled, (::nn::sf::Out<bool> isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsBatteryChargingEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsBatteryChargingEnabled)
    }

    // nn::Result AcquireControllerPowerSupply() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(AcquireControllerPowerSupply)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireControllerPowerSupply)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireControllerPowerSupply)
    }

    // nn::Result ReleaseControllerPowerSupply() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ReleaseControllerPowerSupply)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReleaseControllerPowerSupply)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReleaseControllerPowerSupply)
    }

    // nn::Result OpenSession(nn::sf::Out<nn::sf::SharedPointer<nn::psm::IPsmSession>> outSession) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::psm::IPsmSession>> outSession))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSession)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSession)
    }

    // nn::Result EnableEnoughPowerChargeEmulation() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableEnoughPowerChargeEmulation)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableEnoughPowerChargeEmulation)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableEnoughPowerChargeEmulation)
    }

    // nn::Result DisableEnoughPowerChargeEmulation() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableEnoughPowerChargeEmulation)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableEnoughPowerChargeEmulation)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableEnoughPowerChargeEmulation)
    }

    // nn::Result EnableFastBatteryCharging() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableFastBatteryCharging)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableFastBatteryCharging)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableFastBatteryCharging)
    }

    // nn::Result DisableFastBatteryCharging() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableFastBatteryCharging)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableFastBatteryCharging)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableFastBatteryCharging)
    }

    // nn::Result GetBatteryVoltageState(nn::sf::Out<int> outBatteryVoltageState) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryVoltageState, (::nn::sf::Out<int> outBatteryVoltageState))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBatteryVoltageState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBatteryVoltageState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBatteryVoltageState)
    }

    // nn::Result GetRawBatteryChargePercentage(nn::sf::Out<double> rawBatteryCharge) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRawBatteryChargePercentage, (::nn::sf::Out<double> rawBatteryCharge))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRawBatteryChargePercentage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rawBatteryCharge)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRawBatteryChargePercentage)
    }

    // nn::Result IsEnoughPowerSupplied(nn::sf::Out<bool> isEnoughPowerSupplied) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsEnoughPowerSupplied, (::nn::sf::Out<bool> isEnoughPowerSupplied))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsEnoughPowerSupplied)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnoughPowerSupplied)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsEnoughPowerSupplied)
    }

    // nn::Result GetBatteryAgePercentage(nn::sf::Out<double> batteryAge) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryAgePercentage, (::nn::sf::Out<double> batteryAge))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBatteryAgePercentage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(batteryAge)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBatteryAgePercentage)
    }

    // nn::Result GetBatteryChargeInfoEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryChargeInfoEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBatteryChargeInfoEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBatteryChargeInfoEvent)
    }

    // nn::Result GetBatteryChargeInfoFields(nn::sf::Out<nn::psm::BatteryChargeInfoFields> outBatteryChargeInfoFields) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryChargeInfoFields, (::nn::sf::Out<::nn::psm::BatteryChargeInfoFields> outBatteryChargeInfoFields))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBatteryChargeInfoFields)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBatteryChargeInfoFields)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBatteryChargeInfoFields)
    }

    // nn::Result GetBatteryChargeCalibratedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBatteryChargeCalibratedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBatteryChargeCalibratedEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBatteryChargeCalibratedEvent)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::psm::IPsmServer>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::psm::IPsmServer))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBatteryChargePercentage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBatteryChargePercentage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(batteryCharge)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetChargerType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetChargerType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(chargerType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableBatteryCharging)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableBatteryCharging)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableBatteryCharging)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableBatteryCharging)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsBatteryChargingEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsBatteryChargingEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireControllerPowerSupply)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireControllerPowerSupply)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReleaseControllerPowerSupply)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReleaseControllerPowerSupply)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::psm::IPsmSession>), outSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSession)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outSession, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableEnoughPowerChargeEmulation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableEnoughPowerChargeEmulation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableEnoughPowerChargeEmulation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableEnoughPowerChargeEmulation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableFastBatteryCharging)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableFastBatteryCharging)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableFastBatteryCharging)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableFastBatteryCharging)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBatteryVoltageState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBatteryVoltageState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outBatteryVoltageState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRawBatteryChargePercentage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRawBatteryChargePercentage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(rawBatteryCharge)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsEnoughPowerSupplied)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsEnoughPowerSupplied)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isEnoughPowerSupplied)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBatteryAgePercentage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBatteryAgePercentage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(batteryAge)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBatteryChargeInfoEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBatteryChargeInfoEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBatteryChargeInfoFields)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBatteryChargeInfoFields)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outBatteryChargeInfoFields)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBatteryChargeCalibratedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBatteryChargeCalibratedEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBatteryChargePercentage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetChargerType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableBatteryCharging)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableBatteryCharging)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsBatteryChargingEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireControllerPowerSupply)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReleaseControllerPowerSupply)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableEnoughPowerChargeEmulation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableEnoughPowerChargeEmulation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableFastBatteryCharging)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableFastBatteryCharging)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBatteryVoltageState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRawBatteryChargePercentage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsEnoughPowerSupplied)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBatteryAgePercentage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBatteryChargeInfoEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBatteryChargeInfoFields)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBatteryChargeCalibratedEvent)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::psm::IPsmServer))

namespace nn { namespace psm { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IPsmSession, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IPsmSession)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BindStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnbindStateChangeEvent)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetChargerTypeChangeEventEnabled, (bool isEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetPowerSupplyChangeEventEnabled, (bool isEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetBatteryVoltageStateChangeEventEnabled, (bool isEnabled))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IPsmSession)

        ::nn::Result BindStateChangeEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BindStateChangeEvent, (outHandle));
        }

        ::nn::Result UnbindStateChangeEvent() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnbindStateChangeEvent);
        }

        ::nn::Result SetChargerTypeChangeEventEnabled(bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetChargerTypeChangeEventEnabled, (isEnabled));
        }

        ::nn::Result SetPowerSupplyChangeEventEnabled(bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetPowerSupplyChangeEventEnabled, (isEnabled));
        }

        ::nn::Result SetBatteryVoltageStateChangeEventEnabled(bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetBatteryVoltageStateChangeEventEnabled, (isEnabled));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IPsmSession
    {
    public:
        nn::Result BindStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
        nn::Result UnbindStateChangeEvent() NN_NOEXCEPT;
        nn::Result SetChargerTypeChangeEventEnabled(bool isEnabled) NN_NOEXCEPT;
        nn::Result SetPowerSupplyChangeEventEnabled(bool isEnabled) NN_NOEXCEPT;
        nn::Result SetBatteryVoltageStateChangeEventEnabled(bool isEnabled) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result BindStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result UnbindStateChangeEvent() NN_NOEXCEPT;
    nn::Result SetChargerTypeChangeEventEnabled(bool isEnabled) NN_NOEXCEPT;
    nn::Result SetPowerSupplyChangeEventEnabled(bool isEnabled) NN_NOEXCEPT;
    nn::Result SetBatteryVoltageStateChangeEventEnabled(bool isEnabled) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::psm::IPsmSession))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BindStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BindStateChangeEvent, (outHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnbindStateChangeEvent)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnbindStateChangeEvent);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetChargerTypeChangeEventEnabled, (bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetChargerTypeChangeEventEnabled, (isEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPowerSupplyChangeEventEnabled, (bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetPowerSupplyChangeEventEnabled, (isEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetBatteryVoltageStateChangeEventEnabled, (bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetBatteryVoltageStateChangeEventEnabled, (isEnabled));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::psm::IPsmSession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::psm::IPsmSession))

    // nn::Result BindStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BindStateChangeEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BindStateChangeEvent)

    // nn::Result UnbindStateChangeEvent() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnbindStateChangeEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnbindStateChangeEvent)

    // nn::Result SetChargerTypeChangeEventEnabled(bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetChargerTypeChangeEventEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetChargerTypeChangeEventEnabled)

    // nn::Result SetPowerSupplyChangeEventEnabled(bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetPowerSupplyChangeEventEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetPowerSupplyChangeEventEnabled)

    // nn::Result SetBatteryVoltageStateChangeEventEnabled(bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetBatteryVoltageStateChangeEventEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetBatteryVoltageStateChangeEventEnabled)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::psm::IPsmSession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::psm::IPsmSession))

    // nn::Result BindStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BindStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BindStateChangeEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BindStateChangeEvent)
    }

    // nn::Result UnbindStateChangeEvent() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnbindStateChangeEvent)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnbindStateChangeEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnbindStateChangeEvent)
    }

    // nn::Result SetChargerTypeChangeEventEnabled(bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetChargerTypeChangeEventEnabled, (bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetChargerTypeChangeEventEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetChargerTypeChangeEventEnabled)
    }

    // nn::Result SetPowerSupplyChangeEventEnabled(bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPowerSupplyChangeEventEnabled, (bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetPowerSupplyChangeEventEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetPowerSupplyChangeEventEnabled)
    }

    // nn::Result SetBatteryVoltageStateChangeEventEnabled(bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetBatteryVoltageStateChangeEventEnabled, (bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetBatteryVoltageStateChangeEventEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetBatteryVoltageStateChangeEventEnabled)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::psm::IPsmSession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::psm::IPsmSession))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BindStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BindStateChangeEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnbindStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnbindStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetChargerTypeChangeEventEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetChargerTypeChangeEventEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetPowerSupplyChangeEventEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetPowerSupplyChangeEventEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetBatteryVoltageStateChangeEventEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetBatteryVoltageStateChangeEventEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BindStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnbindStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetChargerTypeChangeEventEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetPowerSupplyChangeEventEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetBatteryVoltageStateChangeEventEnabled)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::psm::IPsmSession))
