﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief PSM ライブラリのテレメトリ用の型の宣言。
 */

#pragma once

namespace nn { namespace psm {

struct BatteryChargeInfoFields
{
    int inputCurrentLimit;      //!< 入力電流上限
    int boostModeCurrentLimit;  //!< 出力電流上限
    int fastChargeCurrentLimit; //!< 充電電流上限
    int chargeVoltageLimit;     //!< 充電電圧上限
    int chargeConfiguration;    //!< 充電設定
    bool hizMode;               //!< Hi-Z モード
    bool chargeEnabled;         //!< nCE 端子
    int powerSupplyPath;        //!< 給電経路

    int batteryTemperature;     //!< 電池温度
    int batteryChargePercent;   //!< 電池残量
    int batteryChargeVoltage;   //!< 電池電圧
    int batteryAge;             //!< 電池劣化

    int powerRole;              //!< パワーロール
    int powerSupplyType;        //!< 給電方式
    int powerSupplyVoltage;     //!< 供給電圧
    int powerSupplyCurrent;     //!< 供給電流

    bool fastBatteryChargingEnabled;    //!< 高速充電モード
    bool controllerPowerSupplyAcquired; //!< コントローラ給電要求
    bool otgRequested;                  //!< OTG 要求

    //!< BatteryChargeInfoFields の各要素を単純にクリアします。システムの初期値と一致することの保証はしません。
    void Clear() NN_NOEXCEPT
    {
        inputCurrentLimit         = 0;
        fastChargeCurrentLimit    = 0;
        boostModeCurrentLimit     = 0;
        chargeVoltageLimit        = 0;
        chargeConfiguration       = 0;
        hizMode                   = false;
        chargeEnabled             = false;
        powerSupplyPath           = 0;

        batteryTemperature        = 0;
        batteryChargePercent      = 0;
        batteryChargeVoltage      = 0;
        batteryAge                = 0;

        powerRole                 = 0;
        powerSupplyType           = 0;
        powerSupplyVoltage        = 0;
        powerSupplyCurrent        = 0;

        fastBatteryChargingEnabled    = false;
        controllerPowerSupplyAcquired = false;
        otgRequested                  = false;
    }
};

}} // namespace nn::psm
