﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace prepo { namespace detail { namespace service { namespace util {

/*!
    @brief      第一引数の値を第二引数で切り上げた値を返します。

    @param[in]  x   切り上げられる数。
    @param[in]  y   切り上げる数。

    @pre
        - y は二の累乗。

    @return     計算結果。
*/
template <class T>
constexpr T RoundUp(T&& x, T&& y)
{
    NN_STATIC_ASSERT(std::is_unsigned<T>::value);
    return (x + y - 1) & ~(y - 1);
}

}}}}}
