﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/prepo/detail/service/prepo_Common.h>

namespace nn { namespace prepo { namespace detail { namespace service { namespace core {

/*!
    @brief      レポートデータのアップロードスレッドです。
*/
class UploadThread
{
public:
    /*!
        @brief      スレッドの実行を開始します。
    */
    static void Start() NN_NOEXCEPT;

    /*!
        @brief      スレッドの実行を停止します。
    */
    static void Stop() NN_NOEXCEPT;

    /*!
        @brief      レポートデータの送信を要求します。
    */
    static void RequestTransmission() NN_NOEXCEPT;

    /*!
        @brief      バックグラウンドでのレポートデータの送信を要求します。
    */
    static void RequestTransmissionForBackground() NN_NOEXCEPT;

    /*!
        @brief      転送状態を取得します。

        @param[in]  category    レポートの分類。

        @return     転送状態。
    */
    static TransmissionStatus GetTransmissionStatus(ReportCategory category) NN_NOEXCEPT;

    /*!
        @brief      最後に発生した送信時のエラーを取得します。

        @param[in]  category    レポートの分類。

        @return     最後に発生した送信時のエラー。
    */
    static nn::Result GetLastError(ReportCategory category) NN_NOEXCEPT;

    /*!
        @brief      システムが全起床状態になったことを通知します。
    */
    static void NotifySystemFullAwaked() NN_NOEXCEPT;

    /*!
        @brief      システムがスリープに入る準備を行ったことを通知します。

        @param[in]  isFromFullAwake 全起床状態からのスリープかどうか。
    */
    static void NotifySystemSleepReady(bool isFromFullAwake) NN_NOEXCEPT;
};

}}}}}
