﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/prepo/detail/service/prepo_Common.h>

namespace nn { namespace prepo { namespace detail { namespace service { namespace core {

/*!
    @brief      デバッグ設定を取得するためのクラスです。
*/
class DebugSettings
{
public:
    /*!
        @brief      バックグラウンド処理が有効かどうか調べます。

        @return     有効なときに true、そうでないときに false。
    */
    static bool IsBackgroundProcessingEnabled() NN_NOEXCEPT;

    /*!
        @brief      送信処理の最短実行間隔を取得します。

        @return     送信処理の最短実行間隔。

        @details
                    レポートファイルが送信可能な状態でも、この時間より短い間隔で、送信処理が実行されることはありません。

                    頻繁に送信処理が実行されることで、サーバーに負荷を掛けないために設定されています。
    */
    static nn::TimeSpan GetTransmissionIntervalMin() NN_NOEXCEPT;

    /*!
        @brief      送信処理の最短リトライ間隔を取得します。

        @return     送信処理の最短リトライ間隔。
    */
    static nn::TimeSpan GetTransmissionRetryIntervalMin() NN_NOEXCEPT;

    /*!
        @brief      送信処理の最長リトライ間隔を取得します。

        @return     送信処理の最長リトライ間隔。
    */
    static nn::TimeSpan GetTransmissionRetryIntervalMax() NN_NOEXCEPT;

    /*!
        @brief      スリープ時の送信処理の実行間隔を取得します。

        @return     スリープ時の送信処理の実行間隔。
    */
    static nn::TimeSpan GetTransmissionIntervalInSleep() NN_NOEXCEPT;

    /*!
        @brief      レポート保存時のログ出力が有効かどうか調べます。

        @return     有効なときに true、そうでないときに false。
    */
    static bool IsOutputSaveLogEnabled() NN_NOEXCEPT;

    /*!
        @brief      統計情報の保存処理の最短実行間隔を取得します。

        @return     統計情報の保存処理の最短実行間隔。

        @details
                    統計情報が更新されても、この時間より短い間隔で、保存処理が実行されることはありません。

                    頻繁に保存処理が実行されることで、ストレージに負荷を掛けないために設定されています。
    */
    static nn::TimeSpan GetStatisticsSaveIntervalMin() NN_NOEXCEPT;

    /*!
        @brief      統計情報のレポートバッファ追加処理の実行間隔を取得します。

        @return     統計情報のレポートバッファ追加処理の実行間隔。
    */
    static nn::TimeSpan GetStatisticsPostInterval() NN_NOEXCEPT;
};

}}}}}
