﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_SharedMemory.h>
#include <nn/util/util_Optional.h>
#include <nn/pl/pl_SharedFontApi.h>
#include <nn/pl/pl_SharedFontApiForSystem.h>
#include <nn/pl/detail/pl_ISharedFontManager.sfdl.h>

namespace nn { namespace pl {

namespace detail {
    const size_t SharedFontMemorySize = 17 * 1024 * 1024;
    const size_t ExtraSharedFontMemorySize = 2 * 1024 * 1024;
}

namespace srv {

class SharedFontManagerServer
{
public:
    SharedFontManagerServer() NN_NOEXCEPT;
    ~SharedFontManagerServer() NN_NOEXCEPT;

    nn::Result Initialize() NN_NOEXCEPT;

    nn::Result RequestLoad(std::int32_t sharedFontType) NN_NOEXCEPT;
    nn::Result GetLoadState(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> loadState) const NN_NOEXCEPT;
    nn::Result GetSize(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> size) const NN_NOEXCEPT;
    nn::Result GetSharedMemoryAddressOffset(std::int32_t sharedFontType, nn::sf::Out<std::int32_t> offset) const NN_NOEXCEPT;
    nn::Result GetSharedMemoryNativeHandle(nn::sf::Out<nn::sf::NativeHandle> outHandle) const NN_NOEXCEPT;
    nn::Result GetSharedFontInOrderOfPriority(nn::sf::Out<bool> outAllFontLoaded, nn::sf::Out<std::int32_t> outFontCount, const nn::sf::OutArray<std::int32_t>& outTypes, const nn::sf::OutArray<std::int32_t>& outOffsets, const nn::sf::OutArray<std::int32_t>& outSizes, nn::settings::LanguageCode languageCode) NN_NOEXCEPT;
    nn::Result GetSharedFontInOrderOfPriorityForSystem(nn::sf::Out<bool> outAllFontLoaded, nn::sf::Out<std::int32_t> outFontCount, const nn::sf::OutArray<std::int32_t>& outTypes, const nn::sf::OutArray<std::int32_t>& outOffsets, const nn::sf::OutArray<std::int32_t>& outSizes, nn::settings::LanguageCode languageCode) NN_NOEXCEPT;
private:

    nn::os::SharedMemoryType    m_SharedMemoryType;
    nn::os::SharedMemoryType    m_ExtraSharedMemoryType;
    nn::os::NativeHandle        m_NativeHandle;
    Bit8*                       m_SharedFontBuffer;
    Bit8*                       m_ExtraSharedFontBuffer;

    SharedFontLoadState         m_LoadState[pl::SharedFontTypeForSystem_Max];
    size_t                      m_DataSize[pl::SharedFontTypeForSystem_Max];
    int32_t                     m_AddressOffset[pl::SharedFontTypeForSystem_Max];

    int                         m_LoadRequestCount;
    SharedFontType              m_LoadRequestQueue[pl::SharedFontTypeForSystem_Max];
    mutable nn::os::Mutex       m_LoadMutex;

    bool IsAllFontLoaded() const NN_NOEXCEPT;
    util::optional<int> GetNextLoadIndex() const NN_NOEXCEPT;
    void GetFontInOrder(int32_t* outOffsets, int32_t* outSizes, SharedFontType* types, int typeCount) const NN_NOEXCEPT;
    void GetFontInOrderForSystem(int32_t* outOffsets, int32_t* outSizes, SharedFontTypeForSystem* types, int typeCount) const NN_NOEXCEPT;
    static void FontLoadThreadFunc(void* argv) NN_NOEXCEPT;

};

// アプリ向けのフォント種類定義はシステム向けのフォント定義に内包され、値は一致する。
// これが成り立たなくなる修正を行う場合はマッピング関数などを用意してアプリ向け API の入出力を変換する必要がある。
NN_STATIC_ASSERT(static_cast<int>(pl::SharedFontType_Standard) == static_cast<int>(pl::SharedFontTypeForSystem_Standard));
NN_STATIC_ASSERT(static_cast<int>(pl::SharedFontType_ChineseSimple) == static_cast<int>(pl::SharedFontTypeForSystem_ChineseSimple));
NN_STATIC_ASSERT(static_cast<int>(pl::SharedFontType_ChineseSimpleExtension) == static_cast<int>(pl::SharedFontTypeForSystem_ChineseSimpleExtension));
NN_STATIC_ASSERT(static_cast<int>(pl::SharedFontType_ChineseTraditional) == static_cast<int>(pl::SharedFontTypeForSystem_ChineseTraditional));
NN_STATIC_ASSERT(static_cast<int>(pl::SharedFontType_Korean) == static_cast<int>(pl::SharedFontTypeForSystem_Korean));
NN_STATIC_ASSERT(static_cast<int>(pl::SharedFontType_NintendoExtension) == static_cast<int>(pl::SharedFontTypeForSystem_NintendoExtension));

} // srv

}} // nn::pl
