﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// Shim library header for access to perflog daemon

#pragma once


#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/perflog/OSDependencies.h>


namespace nn { namespace perflog {

typedef uint64_t LogDumpCookie;


// library init
nn::Result Initialize() NN_NOEXCEPT;

// Library finalize
nn::Result Finalize() NN_NOEXCEPT;


nn::Result RegisterTrigger(
    const char* name,
    OSEvent*    pEvent ) NN_NOEXCEPT;

nn::Result BeginDump(
    LogDumpCookie *pCookie ) NN_NOEXCEPT;

nn::Result DumpLine(
    LogDumpCookie cookie,
    uint64_t      threadId,
    uint64_t      timestampNs,
    uint32_t      id,
    const char*   context ) NN_NOEXCEPT;

nn::Result EndDump(
    LogDumpCookie cookie ) NN_NOEXCEPT;

nn::Result TriggerDump(
    const char* mask  ) NN_NOEXCEPT;

nn::Result UnregisterTrigger(
    const char* name  ) NN_NOEXCEPT;

}}  // nn::perflog

