﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief  PlayDataManager から情報を取得する API を定義します。
 */

#include <nn/nn_Common.h>

/**
 * @namespace nn::pdm
 * @brief プレイデータ管理の名前空間です。
 */
namespace nn { namespace pdm {

/**
* @brief        Query 系の API を利用するための初期化を行います。
* @details      Query 系の API を呼び出す前に少なくとも1度呼び出す必要があります。2度目以降の呼び出しでは初期化処理は行われません。
*               複数回呼び出した場合、Notify 系の API の利用を完全に終了するには同じ回数だけ @ref FinalizeForQuery を呼ぶ必要があります。
*/
void InitializeForQuery() NN_NOEXCEPT;

/**
* @brief        Query 系の API の利用を終了します。
* @details      Query 系の API の利用を完全に終了するには @ref FinalizeForQuery を呼んだ回数と同じ回数だけこの関数を呼びだす必要があります。
*/
void FinalizeForQuery() NN_NOEXCEPT;

}}
