﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/pdm/pdm_PrivateTypes.h>
#include <nn/pdm/pdm_SystemTypes.h>

namespace nn { namespace pdm { namespace detail {

PlayEvent MakeAppletEvent(AppletEventType eventType, const nn::ncm::ProgramId& programId, uint32_t version, nn::applet::AppletId appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy PlayLogPolicy) NN_NOEXCEPT;
PlayEvent MakeAppletEvent(AppletEventType eventType, const nn::ncm::ProgramId& programId, uint32_t version, nn::applet::AppletId appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy, const time::PosixTime& userClockTime, const time::PosixTime& networkClockTime, int64_t steadyClockTime) NN_NOEXCEPT;
PlayEvent MakeLibraryAppletEvent(AppletEventType eventType, const nn::ncm::ProgramId& mainProgramId, nn::applet::LibraryAppletMode libraryAppletMode, nn::applet::AppletId appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy PlayLogPolicy) NN_NOEXCEPT;
PlayEvent MakeLibraryAppletEvent(AppletEventType eventType, const nn::ncm::ProgramId& mainProgramId, nn::applet::LibraryAppletMode libraryAppletMode, nn::applet::AppletId appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy, const time::PosixTime& userClockTime, const time::PosixTime& networkClockTime, int64_t steadyClockTime) NN_NOEXCEPT;
PlayEvent MakePowerStateChangeEvent(PowerStateChangeEventType eventType) NN_NOEXCEPT;
PlayEvent MakePowerStateChangeEvent(PowerStateChangeEventType eventType, const time::PosixTime& userClockTime, const time::PosixTime& networkClockTime, int64_t steadyClockTime) NN_NOEXCEPT;
PlayEvent MakeOperationModeChangeEvent(pdm::OperationMode operationMode) NN_NOEXCEPT;
PlayEvent MakeOperationModeChangeEvent(pdm::OperationMode operationMode, const time::PosixTime& userClockTime, const time::PosixTime& networkClockTime, int64_t steadyClockTime) NN_NOEXCEPT;
PlayEvent MakeUserAccountEvent(UserAccountEventType eventType, const nn::account::Uid& user) NN_NOEXCEPT;
PlayEvent MakeUserAccountEvent(UserAccountEventType eventType, const nn::account::Uid& user, const time::PosixTime& userClockTime, const time::PosixTime& networkClockTime, int64_t steadyClockTime) NN_NOEXCEPT;
PlayEvent MakeNetworkServiceAccountAvailableEvent(const nn::account::Uid& user, const nn::account::NetworkServiceAccountId& nid) NN_NOEXCEPT;
PlayEvent MakeNetworkServiceAccountAvailableEvent(const nn::account::Uid& user, const nn::account::NetworkServiceAccountId& nid, const time::PosixTime& userClockTime, const time::PosixTime& networkClockTime, int64_t steadyClockTime) NN_NOEXCEPT;
PlayEvent MakeSteadyClockResetEvent() NN_NOEXCEPT;
PlayEvent MakeSteadyClockResetEvent(const time::PosixTime& userClockTime, const time::PosixTime& networkClockTime, int64_t steadyClockTime) NN_NOEXCEPT;

}}}
