﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief PCV ドライバライブラリのエラーレポート用の型宣言
 */

#pragma once

#include <nn/pcv/pcv_Modules-spec.nx.h>
#include <nn/pcv/pcv_PowerDomains-spec.nx.h>

namespace nn {
namespace pcv {

const int32_t DvfsTableMaxDataCount = 32;

// エラーレポートで扱うモジュールのリスト
const Module ModuleListForErrorReport[] = {
    Module_Cpu,
    Module_Gpu,
    Module_Disp1,
    Module_Disp2,
    Module_Tsec,
    Module_Mselect,
    Module_Sor1,
    Module_Hostx,
    Module_Vic,
    Module_Nvenc,
    Module_Nvjpg,
    Module_Nvdec,
    Module_Ape,
    Module_AudioDsp,
    Module_Emc,
    Module_Dsi,
    Module_SysBus,
    Module_XusbSs,
    Module_XusbHost,
    Module_XusbDevice,
    Module_Gpuaux,
    Module_Pcie,
    Module_Apbdma,
    Module_Sdmmc1,
    Module_Sdmmc2,
    Module_Sdmmc4,
};
const int ModuleStateTableSize = sizeof(ModuleListForErrorReport) / sizeof(ModuleListForErrorReport[0]);

// エラーレポートで扱う電源ドメインのリスト
const PowerDomain PowerDomainListForErrorReportForMax77621[] = {
    PowerDomain_Max77620_Sd0,
#if !defined NN_BUILD_CONFIG_HARDWARE_JETSONTK2
    PowerDomain_Max77621_Cpu,
    PowerDomain_Max77621_Gpu,
#endif
};

const int PowerDomainStateTableSizeForMax77621 = sizeof(PowerDomainListForErrorReportForMax77621) / sizeof(PowerDomainListForErrorReportForMax77621[0]);

// Iowa のエラーレポートで扱う電源ドメインのリスト
const PowerDomain PowerDomainListForErrorReportForMax77812[] = {
    PowerDomain_Max77620_Sd0,
#if !defined NN_BUILD_CONFIG_HARDWARE_JETSONTK2
    PowerDomain_Max77812_Cpu,
    PowerDomain_Max77812_Gpu,
#endif
};

const int PowerDomainStateTableSizeForMax77812 = sizeof(PowerDomainListForErrorReportForMax77812) / sizeof(PowerDomainListForErrorReportForMax77812[0]);

const int PowerDomainStateTableSizeMax = PowerDomainStateTableSizeForMax77621 > PowerDomainStateTableSizeForMax77812
    ? PowerDomainStateTableSizeForMax77621
    : PowerDomainStateTableSizeForMax77812;

// GetFuseInfo() で得られる値の要素数
const int FuseValueCount = 6;

} // pcv
} // nn
