﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   PCV ドライバライブラリのサスペンド・レジューム機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn {
namespace pcv {
namespace driver {

//! @name サスペンド・レジューム
//! @{

/**
 * @brief クロック制御部をサスペンドします。
 *
 * @pre
 * @post
 * @details
 */
Result SuspendClocks() NN_NOEXCEPT;

/**
 * @brief クロック制御部をレジュームします。
 *
 * @pre
 * @post
 * @details
 */
Result ResumeClocks() NN_NOEXCEPT;

/**
 * @brief 電源制御部をサスペンドします。
 *
 * @pre
 * @post
 * @details
 */
Result SuspendVoltage() NN_NOEXCEPT;

/**
 * @brief 電源制御部をレジュームします。
 *
 * @pre
 * @post
 * @details
 */
Result ResumeVoltage() NN_NOEXCEPT;

//! @}

} // dirver
} // pcv
} // nn


