﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace pcv { namespace driver { namespace detail {

struct ModuleNameInfo
{
    Module module;
    const char* name;
};

#define NN_PCV_DRIVER_DETAIL_MODULE_NAME(module) {(module), #module}

const ModuleNameInfo ModuleNames[] =
{
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Cpu),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Gpu),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_I2s1),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_I2s2),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_I2s3),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Pwm),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_I2c1),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_I2c2),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_I2c3),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_I2c4),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_I2c5),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_I2c6),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Spi1),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Spi2),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Spi3),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Spi4),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Disp1),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Disp2),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Isp),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Vi),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Sdmmc1),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Sdmmc2),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Sdmmc3),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Sdmmc4),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Owr),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Csite),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Tsec),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Mselect),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Hda2codec2x),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Actmon),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_I2cSlow),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Sor1),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Sata),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Hda),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_XusbCoreHostSrc),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_XusbFalconSrc),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_XusbFsSrc),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_XusbCoreDevSrc),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_XusbSsSrc),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_UartA),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_UartB),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_UartC),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_UartD),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Hostx),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Entropy),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_SocTherm),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Vic),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Nvenc),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Nvjpg),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Nvdec),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Qspi),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_ViI2c),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Tsecb),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Ape),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_AudioDsp),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_AudioUart),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Emc),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Plle),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_PlleHwSeq),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Dsi),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Maud),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Dpaux1),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_MipiCal),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_UartFstMipiCal),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Osc),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_SysBus),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_SorSafe),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_XusbSs),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_XusbHost),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_XusbDevice),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Extperiph1),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Ahub),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Hda2hdmicodec),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Gpuaux),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_UsbD),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Usb2),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Pcie),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Afi),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_PciExClk),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_PExUsbPhy),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_XUsbPadCtl),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Apbdma),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_Usb2TrkClk),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_XUsbIoPll),
    NN_PCV_DRIVER_DETAIL_MODULE_NAME(Module_XUsbIoPllHwSeq),
};

}}}} // namespace nn::pcv::driver::detail
