﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/pctl/pctl_TypesWatcher.h>
#include <nn/time/time_CalendarTime.h>
#include <nn/time/time_LocationName.h>
#include <nn/time/time_PosixTime.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

struct PlayTimerStatusVer1
{
    PlayTimerSettings settings;
    bool isTimerRunning;       // タイマー稼動中かどうか
    nn::time::PosixTime startTimeForSpend; // 消費時間計算の基準時刻(秒)
    nn::time::PosixTime stopTimeForSpend;  // 消費時間計算の基準時刻(秒)
    nn::time::CalendarTime lastCheckDate; // 最終確認時の日付
    nn::time::LocationName lastTimeLocationName; // 最終確認時のタイムゾーン地域名
};

namespace test
{
    struct PlayTimerStatusVer1WithPadding
    {
        PlayTimerSettings settings;
        bool isTimerRunning;       // タイマー稼動中かどうか
        uint8_t _padding1[3];
        nn::time::PosixTime startTimeForSpend; // 消費時間計算の基準時刻(秒)
        nn::time::PosixTime stopTimeForSpend;  // 消費時間計算の基準時刻(秒)
        nn::time::CalendarTime lastCheckDate; // 最終確認時の日付
        nn::time::LocationName lastTimeLocationName; // 最終確認時のタイムゾーン地域名
        uint8_t _padding2[4];
    };
    NN_STATIC_ASSERT(sizeof(PlayTimerStatusVer1WithPadding) == sizeof(PlayTimerStatusVer1));
}

struct PlayTimerStatusVer3
{
    PlayTimerSettings settings;
    bool isTimerRunning;       // タイマー稼動中かどうか
    uint8_t _padding1[3];
    nn::time::PosixTime startTimeForSpend; // 消費時間計算の基準時刻(秒)
    nn::time::PosixTime stopTimeForSpend;  // 消費時間計算の基準時刻(秒)
    nn::time::CalendarTime lastCheckDate; // 最終確認時の日付
    nn::time::LocationName lastTimeLocationName; // 最終確認時のタイムゾーン地域名
    uint8_t _padding2[4];
    nn::time::PosixTime alarmDisableExpirationTime; // アラーム一時無効が終わる時刻(0 値の場合は非無効状態)
};
typedef PlayTimerStatusVer3 PlayTimerStatus;

}}}}}
