﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/npns/npns_Types.h>
#include <nn/pctl/detail/service/pctl_ServiceConfig.h>
#include <nn/pctl/detail/service/common/pctl_AsyncContext.h>
#include <nn/pctl/detail/service/common/pctl_Cancelable.h>
#include <nn/pctl/detail/service/system/pctl_Settings.h>
#include <nn/pctl/detail/service/watcher/pctl_ServerResource.h>
#include <nn/pctl/detail/service/watcher/pctl_WatcherData.h>
#include <nn/pctl/detail/service/watcher/dispatcher/pctl_PairingDispatcher.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

////////////////////////////////////////////////////////////////////////////////

class RequestPairing : public common::AsyncContext
{
public:
    static const size_t MaxPairingCodeLength = dispatcher::FindDeviceWithPairingCodeDispatcher::MaxPairingCodeLength; // NULL文字含まず

    explicit RequestPairing(common::Cancelable* pCancelable) NN_NOEXCEPT :
        m_pCancelable(pCancelable)
    {
    }

    void SetParameters(ServerDeviceId* outDeviceId, size_t* actualOwnerCountPointer, const char* pairingCode, size_t codeLength, ServerDeviceOwner* pOwners, size_t maxOwnerCount) NN_NOEXCEPT
    {
        if (codeLength > MaxPairingCodeLength)
        {
            codeLength = MaxPairingCodeLength;
        }
        std::memcpy(m_PairingCode, pairingCode, sizeof(char) * codeLength);
        m_PairingCode[codeLength] = 0;
        m_pDeviceId = outDeviceId;
        m_pOwners = pOwners;
        m_MaxOwnerCount = maxOwnerCount;
        m_ActualOwnerCountPointer = actualOwnerCountPointer;
    }

    virtual void CloseContext() NN_NOEXCEPT NN_OVERRIDE
    {
        delete this;
    }

    virtual nn::Result Execute(common::NetworkBuffer& bufferInfo) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Cancel() NN_NOEXCEPT NN_OVERRIDE;
    virtual bool IsCancelTriggered() const NN_NOEXCEPT NN_OVERRIDE
    {
        return m_pCancelable->IsCanceled();
    }

private:

    common::Cancelable* m_pCancelable;
    nn::npns::NotificationToken m_NotificationToken;
    char m_PairingCode[MaxPairingCodeLength + 1];
    ServerDeviceId* m_pDeviceId;
    ServerDeviceOwner* m_pOwners;
    size_t m_MaxOwnerCount;
    size_t* m_ActualOwnerCountPointer;
};

////////////////////////////////////////////////////////////////////////////////

class AuthorizePairing : public common::AsyncContext
{
public:
    explicit AuthorizePairing(common::Cancelable* pCancelable) NN_NOEXCEPT :
        m_pCancelable(pCancelable)
    {
    }

    void SetParameters(ServerDeviceId deviceId) NN_NOEXCEPT
    {
        m_DeviceId = deviceId;
    }

    virtual void CloseContext() NN_NOEXCEPT NN_OVERRIDE
    {
        delete this;
    }

    virtual nn::Result Execute(common::NetworkBuffer& bufferInfo) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Cancel() NN_NOEXCEPT NN_OVERRIDE;
    virtual bool IsCancelTriggered() const NN_NOEXCEPT NN_OVERRIDE
    {
        return m_pCancelable->IsCanceled();
    }

private:

    common::Cancelable* m_pCancelable;
    ServerDeviceId m_DeviceId;
    EtagInfo m_Etag;
};

////////////////////////////////////////////////////////////////////////////////

}}}}}
