﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/pctl/detail/service/common/pctl_Cancelable.h>
#include <nn/pctl/detail/service/common/pctl_NetworkBuffer.h>
#include <nn/pctl/detail/service/watcher/pctl_ServerResource.h>
#include <nn/pctl/detail/service/watcher/pctl_WatcherData.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher { namespace dispatcher {

////////////////////////////////////////////////////////////////////////////////

//! @brief 指定のデバイスとアカウントに対する連携を解除します。
class UnlinkDeviceDispatcher
{
public:
    static nn::Result Execute(common::NetworkBuffer& bufferInfo, common::Cancelable* pCancelable, const char* token,
        ServerDeviceId deviceId, NintendoAccountId accountId) NN_NOEXCEPT;
};

////////////////////////////////////////////////////////////////////////////////

}}}}}}
