﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>

#include <nn/os/os_SdkMutex.h>
#include <nn/os/os_SystemEvent.h>

namespace nn { namespace pctl { namespace detail {

class EventObjectHolder
{
public:
    EventObjectHolder() NN_NOEXCEPT :
        m_EventObject(),
        m_IsInitialized(false)
    {
    }

    bool IsInitialized() const NN_NOEXCEPT
    {
        return m_IsInitialized;
    }

    void InitializeWithReadableHandle(nn::os::NativeHandle eventObjectReadable, bool isManaged, nn::os::EventClearMode clearMode) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(!m_IsInitialized);
        m_EventObject.AttachReadableHandle(eventObjectReadable, isManaged, clearMode);
        m_IsInitialized = true;
    }

    nn::os::SystemEvent* GetSystemEvent() NN_NOEXCEPT
    {
        return &m_EventObject;
    }

    // lock_guard 対応
    void lock() NN_NOEXCEPT
    {
        m_Mutex.Lock();
    }

    void unlock() NN_NOEXCEPT
    {
        m_Mutex.Unlock();
    }

private:
    nn::os::SystemEvent m_EventObject;
    nn::os::SdkMutex m_Mutex;
    bool m_IsInitialized;
};

}}}
