﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/pctl/detail/ipc/pctl_IpcConfig.h>
#include <nn/pctl/detail/ipc/pctl_IParentalControlService.sfdl.h>

namespace nn { namespace pctl { namespace detail { namespace ipc {

nn::Result InitializeIpcSessionIfNeeded() NN_NOEXCEPT;
// Watcher向けに特別な初期化処理を行う
// (InitializeIpcSessionIfNeeded の処理は不要)
nn::Result InitializeWatcherIpcSessionIfNeeded() NN_NOEXCEPT;
#if defined(NN_DETAIL_PCTL_CONFIG_USE_FINALIZE_SESSION)
void FinalizeIpcSessionImpl() NN_NOEXCEPT;
void FinalizeIpcSession() NN_NOEXCEPT;
#endif
IParentalControlService* GetServiceImpl() NN_NOEXCEPT;

IParentalControlService* GetService() NN_NOEXCEPT;
IParentalControlService* GetServiceForWatcher() NN_NOEXCEPT;

}}}}
