﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      pcm モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_PCM_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCM_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCM_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCM_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCM_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCM_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCM_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCM_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCM_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCM_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCM_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCM_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCM_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCM_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCM_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCM_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCM_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCM_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCM_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCM_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcm, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCM_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Trace, 0, format, args)
#define NN_DETAIL_PCM_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Trace, 1, format, args)
#define NN_DETAIL_PCM_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Trace, 2, format, args)
#define NN_DETAIL_PCM_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Trace, 3, format, args)

#define NN_DETAIL_PCM_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Info, 0, format, args)
#define NN_DETAIL_PCM_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Info, 1, format, args)
#define NN_DETAIL_PCM_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Info, 2, format, args)
#define NN_DETAIL_PCM_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Info, 3, format, args)

#define NN_DETAIL_PCM_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Warn, 0, format, args)
#define NN_DETAIL_PCM_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Warn, 1, format, args)
#define NN_DETAIL_PCM_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Warn, 2, format, args)
#define NN_DETAIL_PCM_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Warn, 3, format, args)

#define NN_DETAIL_PCM_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Error, 0, format, args)
#define NN_DETAIL_PCM_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Error, 1, format, args)
#define NN_DETAIL_PCM_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Error, 2, format, args)
#define NN_DETAIL_PCM_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Error, 3, format, args)

#define NN_DETAIL_PCM_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Fatal, 0, format, args)
#define NN_DETAIL_PCM_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Fatal, 1, format, args)
#define NN_DETAIL_PCM_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Fatal, 2, format, args)
#define NN_DETAIL_PCM_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcm, Fatal, 3, format, args)

#define NN_DETAIL_PCM_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Trace, 0, text, length)
#define NN_DETAIL_PCM_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Trace, 1, text, length)
#define NN_DETAIL_PCM_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Trace, 2, text, length)
#define NN_DETAIL_PCM_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Trace, 3, text, length)

#define NN_DETAIL_PCM_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Info, 0, text, length)
#define NN_DETAIL_PCM_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Info, 1, text, length)
#define NN_DETAIL_PCM_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Info, 2, text, length)
#define NN_DETAIL_PCM_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Info, 3, text, length)

#define NN_DETAIL_PCM_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Warn, 0, text, length)
#define NN_DETAIL_PCM_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Warn, 1, text, length)
#define NN_DETAIL_PCM_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Warn, 2, text, length)
#define NN_DETAIL_PCM_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Warn, 3, text, length)

#define NN_DETAIL_PCM_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Error, 0, text, length)
#define NN_DETAIL_PCM_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Error, 1, text, length)
#define NN_DETAIL_PCM_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Error, 2, text, length)
#define NN_DETAIL_PCM_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Error, 3, text, length)

#define NN_DETAIL_PCM_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Fatal, 0, text, length)
#define NN_DETAIL_PCM_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Fatal, 1, text, length)
#define NN_DETAIL_PCM_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Fatal, 2, text, length)
#define NN_DETAIL_PCM_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcm, Fatal, 3, text, length)
