﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Event.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_Thread.h>
#include <nn/os/os_Mutex.h>
#include <nn/omm/omm_Api.h>
#include <nn/omm/srv/omm_AwakeModeManager.h>
#include <nn/omm/srv/omm_CradleLedController.h>
#include <nn/omm/srv/omm_CradleObserver.h>
#include <nn/omm/srv/omm_DisplayManager.h>
#include <nn/omm/detail/omm_IOperationModeManager.sfdl.h>
#include <nn/usb/pd/usb_PdCradleLib.h>
#include <nn/vi/vi_Types.h>
#include <nn/sf/sf_NativeHandle.h>

namespace nn { namespace omm { namespace srv {
    class OperationModeManager : public CradleObserver::IHandler
    {
    public:
        OperationModeManager() NN_NOEXCEPT;

        void InitializeForShowStartupLogo() NN_NOEXCEPT;
        void Initialize() NN_NOEXCEPT;
        void ShowStartupLogo() NN_NOEXCEPT;
        void HideStartupLogo() NN_NOEXCEPT;

        Result GetOperationMode(sf::Out<OperationMode> outValue) NN_NOEXCEPT;
        Result GetOperationModeChangeEvent(sf::Out<sf::NativeHandle> outValue) NN_NOEXCEPT;
        Result EnableAudioVisual() NN_NOEXCEPT;
        Result DisableAudioVisual() NN_NOEXCEPT;
        Result EnterSleepAndWait(sf::NativeHandle handle) NN_NOEXCEPT;
        Result GetCradleStatus(sf::Out<CradleStatus> outValue) NN_NOEXCEPT;
        Result GetCradleFwVersion(sf::Out<uint32_t> outPdcH, sf::Out<uint32_t> outPdcA, sf::Out<uint32_t> outMcu, sf::Out<uint32_t> outDp2Hdmi) NN_NOEXCEPT;
        Result FadeInDisplay() NN_NOEXCEPT;
        Result FadeOutDisplay() NN_NOEXCEPT;
        Result NotifyCecSettingsChanged() NN_NOEXCEPT;
        Result SetApplicationCecSettingsAndNotifyChanged(int mode) NN_NOEXCEPT;
        Result SetOperationModePolicy(OperationModePolicy policy) NN_NOEXCEPT;
        Result GetDefaultDisplayResolution(sf::Out<int32_t> outWidth, sf::Out<int32_t> outHeight) NN_NOEXCEPT;
        Result GetDefaultDisplayResolutionChangeEvent(sf::Out<sf::NativeHandle> outValue) NN_NOEXCEPT;
        Result UpdateDefaultDisplayResolution() NN_NOEXCEPT;
        Result ShouldSleepOnBoot(sf::Out<bool> pOut) NN_NOEXCEPT;
        Result NotifyHdcpApplicationExecutionStarted() NN_NOEXCEPT;
        Result NotifyHdcpApplicationExecutionFinished() NN_NOEXCEPT;
        Result NotifyHdcpApplicationDrawingStarted() NN_NOEXCEPT;
        Result NotifyHdcpApplicationDrawingFinished() NN_NOEXCEPT;
        Result GetHdcpAuthenticationFailedEvent(sf::Out<sf::NativeHandle> outValue) NN_NOEXCEPT;
        Result GetHdcpAuthenticationFailedEmulationEnabled(sf::Out<bool> pOut) NN_NOEXCEPT;
        Result SetHdcpAuthenticationFailedEmulation(bool enable) NN_NOEXCEPT;
        Result GetHdcpState(sf::Out<HdcpState> outValue) NN_NOEXCEPT;
        Result GetHdcpStateChangeEvent(sf::Out<sf::NativeHandle> outValue) NN_NOEXCEPT;
        Result ShowCardUpdateProcessing() NN_NOEXCEPT;

        virtual void OnMounted() NN_NOEXCEPT NN_OVERRIDE;
        virtual void OnUnmounted() NN_NOEXCEPT NN_OVERRIDE;

        OperationMode GetOperationMode() const NN_NOEXCEPT;
    private:
        void InitializePolicy() NN_NOEXCEPT;
        void EnableHandheldDisplay() NN_NOEXCEPT;
        void EnableConsoleDisplay() NN_NOEXCEPT;
        void DisableAllDisplay() NN_NOEXCEPT;
        void NotifyOperationModeChanged() NN_NOEXCEPT;
        void SwitchToHandheldMode() NN_NOEXCEPT;
        void SwitchToConsoleMode(bool handleDisplay) NN_NOEXCEPT;
        void StartPowerStateHandler() NN_NOEXCEPT;
        void SetLcdPowerOnAsync() NN_NOEXCEPT;
        void PowerStateHandlerImpl() NN_NOEXCEPT;

        TimeSpan m_SleepFadeInSpan;
        TimeSpan m_SleepFadeOutSpan;
        TimeSpan m_BacklightOffSpanOnHandheldSwitch;

        AwakeModeManager m_AwakeModeManager;
        CradleLedController m_CradleLedController;
        CradleObserver m_CradleObserver;
        DisplayManager m_DisplayManager;
        usb::pd::CradleSession m_PdCradleSession;

        std::atomic<OperationMode> m_Current;
        os::SystemEvent m_ChangeEvent;
        os::Event m_PrecedingLcdProcessingEvent;

        bool m_IsAutoSwitchEnabled;
        bool m_IsImmediatelyAfterAwake;
        bool m_SkipsToTriggerNextOneTouchPlay;
        bool m_ShouldSleepOnBoot;
        bool m_IsStartupLogoShown = false;
        OperationModePolicy m_OperationModePolicy;
        ConsoleStyle m_ConsoleStyle;
    };
}}}
