﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Types.h>
#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/util/util_Optional.h>

#include <array>

namespace nn { namespace olsc { namespace srv { namespace util {

class ActiveUserListBase
{
public:

    NN_IMPLICIT ActiveUserListBase(TimeSpan updateInterval) NN_NOEXCEPT;

    int GetCount() const NN_NOEXCEPT;
    bool IsActive(const account::Uid& uid) const NN_NOEXCEPT;

    void Refresh() NN_NOEXCEPT;
    void ScheduleNextUpdate(const account::Uid& uid) NN_NOEXCEPT;

    TimeSpan GetTimeSpanToNextUpdate() const NN_NOEXCEPT;
    int ListUsersToUpdate(account::Uid out[], const int maxOutCount) const NN_NOEXCEPT;

protected:
    virtual int ListActiveUsers(account::Uid out[], int maxListCount) const NN_NOEXCEPT = 0;

private:
    struct UserInfo
    {
        account::Uid    uid;
        nn::TimeSpan    nextUpdateTime;

        inline static UserInfo Make(const account::Uid& uid, TimeSpan nextUpdateTime) NN_NOEXCEPT
        {
            return { uid, nextUpdateTime };
        }
    };

    mutable os::SdkRecursiveMutex m_Lock;
    std::array<UserInfo, account::UserCountMax> m_UserInfos {};
    int m_Count = 0;
    TimeSpan m_UpdateInterval;

    nn::util::optional<int> FindIndex(const account::Uid& uid) const NN_NOEXCEPT;
};

class ActiveUserList : public ActiveUserListBase
{
public:
    NN_IMPLICIT ActiveUserList(TimeSpan updateInterval) NN_NOEXCEPT;

protected:
    virtual int ListActiveUsers(account::Uid out[], int maxListCount) const NN_NOEXCEPT NN_OVERRIDE;

};

}}}} // nn::olsc::srv::util
