﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_ApplicationId.h>
#include <nn/nn_Result.h>
#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/srv/database/olsc_SeriesInfoDatabase.h>
#include <nn/olsc/srv/database/olsc_SaveDataArchiveInfoCache.h>
#include <nn/olsc/srv/util/olsc_MountManager.h>
#include <nn/olsc/srv/olsc_UserReusableObjectManager.h>

#include <array>

namespace nn { namespace olsc { namespace srv {

const int SeriesInfoDatabaseCount = 3;
class SeriesInfoDatabaseManager : public UserReusableObjectManager<database::SeriesInfoDatabase, SeriesInfoDatabaseCount>
{
    NN_DISALLOW_COPY(SeriesInfoDatabaseManager);
public:
    NN_IMPLICIT SeriesInfoDatabaseManager(util::DefaultMountManager& mountManager) NN_NOEXCEPT
        : m_MountManager(mountManager)
    {
        NN_DETAIL_OLSC_TRACE("SeriesInfoDatabase: %016p\n", this);
    }

    util::WriteMount AcquireWriteMount(const account::Uid& uid) NN_NOEXCEPT
    {
        return m_MountManager.AcquireForWrite(util::DefaultSaveDataTag::UserSeriesInfoSave, uid);
    }

    util::ReadMount AcquireReadMount(const account::Uid& uid) NN_NOEXCEPT
    {
        return m_MountManager.AcquireForRead(util::DefaultSaveDataTag::UserSeriesInfoSave, uid);
    }
protected:
    virtual void EmplaceObject(nn::util::optional<database::SeriesInfoDatabase>& toEmplace, const account::Uid& uid) NN_NOEXCEPT NN_OVERRIDE
    {
        toEmplace.emplace(uid, m_MountManager);
    }

private:
    util::DefaultMountManager& m_MountManager;
};

}}} // namespace nn::olsc::srv
