﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/olsc/srv/database/olsc_PolicyInfoCache.h>
#include <nn/util/util_Execution.h>

namespace nn { namespace olsc { namespace srv {

    class UpdateDataTransferPolicyTask : public nn::util::Executable
    {
    public:
        NN_IMPLICIT UpdateDataTransferPolicyTask(ApplicationId appId, int latestVersion, int launchRequiredVerison, database::PolicyInfoCache& policyInfoCache) NN_NOEXCEPT
            : m_AppId(appId), m_LatestVerison(latestVersion), m_LaunchRequiredVersion(launchRequiredVerison), m_PolicyInfoCache(policyInfoCache)
        {}
    protected:
        virtual Result ExecuteImpl(void* rawBuffer, size_t rawBufferSize) NN_NOEXCEPT NN_OVERRIDE;

    private:
        ApplicationId m_AppId;
        int m_LatestVerison;
        int m_LaunchRequiredVersion;
        database::PolicyInfoCache& m_PolicyInfoCache;
    };

}}} // namespace nn::olsc::srv
