﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/olsc/srv/olsc_TransferTaskAgent.h>
#include <nn/olsc/srv/olsc_TransferTaskFactory.h>

namespace nn { namespace olsc { namespace srv {

struct ExecutionResource
{
    static const size_t BufferSize = 132 * 1024;
    NN_ALIGNAS(std::alignment_of<std::max_align_t>::value)
        char buffer[BufferSize];
    CURL* curlHandle;
};

struct ExecutorConfig
{
    static const int QueueCapacity = 32;
    using ResultOutOfQueueCapacity = olsc::ResultOutOfQueueCapacity;
};

class Executor
    : public nn::util::Executor<ExecutorConfig>
{
public:
    void Execute(ExecutionResource& resource) NN_NOEXCEPT
    {
        nn::util::Executor<ExecutorConfig>::Execute(&resource, sizeof(resource));
    }
};

}}} // ~namespace nn::olsc::srv
