﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 *  @file
 *  @brief      バックグラウンドの動作の停止を管理します。
 */

namespace nn { namespace olsc {
    namespace srv {
        class IStopperObject;
    }

    /**
    *
    *   @brief   バックグラウンドの動作の停止を管理するオブジェクトです。
    *   @details バックグラウンドの処理の停止を行う API を呼び出したときにこのオブジェクトが返されます。
    *            このオブジェクトが破棄されると停止状態が解除されます。
    */
    class Stopper
    {
        NN_DISALLOW_COPY(Stopper);

    public:
        Stopper() NN_NOEXCEPT;
        NN_IMPLICIT Stopper(srv::IStopperObject* stopper) NN_NOEXCEPT;
        ~Stopper() NN_NOEXCEPT;

        Stopper& operator=(Stopper&& rhs) NN_NOEXCEPT;
        Stopper(Stopper&& rhs) NN_NOEXCEPT;

    private:
        friend void swap(Stopper& lhs, Stopper& rhs) NN_NOEXCEPT;
        srv::IStopperObject* m_Stopper;
    };

    void swap(Stopper& lhs, Stopper& rhs) NN_NOEXCEPT;

}} // namespace nn::olsc
