﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentMetaId.h>

namespace nn { namespace olsc {
namespace srv {
class IForbiddenSaveDataIndication;
} // ~namespace nn::olsc::srv

class ForbiddenSaveDataIndication
{
    NN_DISALLOW_COPY(ForbiddenSaveDataIndication);

    friend void swap(ForbiddenSaveDataIndication& lhs, ForbiddenSaveDataIndication& rhs) NN_NOEXCEPT;

private:
    srv::IForbiddenSaveDataIndication* m_pImpl {nullptr};

public:
    ForbiddenSaveDataIndication() NN_NOEXCEPT = default;
    ForbiddenSaveDataIndication(ForbiddenSaveDataIndication&& rhs) NN_NOEXCEPT;
    explicit ForbiddenSaveDataIndication(srv::IForbiddenSaveDataIndication* pImpl) NN_NOEXCEPT;

    ~ForbiddenSaveDataIndication() NN_NOEXCEPT;

    ForbiddenSaveDataIndication& operator =(ForbiddenSaveDataIndication&& rhs) NN_NOEXCEPT;

    void Update(const ncm::ApplicationId appIds[], int count) NN_NOEXCEPT;
};

void swap(ForbiddenSaveDataIndication& lhs, ForbiddenSaveDataIndication& rhs) NN_NOEXCEPT;
}} // ~namespace nn::olsc
