﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 *  @file
 *  @brief  ツール・テスト向け
 */

#include <nn/account.h>
#include <nn/nn_ApplicationId.h>
#include <nn/nn_Result.h>
#include <nn/olsc/olsc_RemoteStorageController.h>
#include <nn/olsc/olsc_TransferTaskTypes.h>
#include <nn/olsc/srv/olsc_InternalTypes.h>

namespace nn { namespace olsc {
    namespace srv {
        class IOlscServiceForSystemService;
    }

    void InitializeForSystemService() NN_NOEXCEPT;
    void FinalizeForSystemService() NN_NOEXCEPT;
    void InitializeWithServiceObject(sf::SharedPointer<srv::IOlscServiceForSystemService> serviceObject) NN_NOEXCEPT;

    void DeleteAllTransferTask() NN_NOEXCEPT;
    void DeleteAllSeriesInfo(const account::Uid& uid) NN_NOEXCEPT;
    void DeleteAllSaveDataArchiveInfoCache(const account::Uid& uid) NN_NOEXCEPT;
    void DeleteAllApplicationSetting(const account::Uid& uid) NN_NOEXCEPT;
    void DeleteAllTransferTaskErrorInfo() NN_NOEXCEPT;
    void DeleteSeriesInfo(const account::Uid& uid, ApplicationId appId) NN_NOEXCEPT;
    void RegisterTransferTaskErrorInfo(const TransferTaskErrorInfo& errorInfo) NN_NOEXCEPT;
    Result AddSaveDataArchiveInfoCache(const account::Uid& uid, srv::SaveDataArchiveInfo& sda) NN_NOEXCEPT;

    void GetSeriesInfo(srv::SeriesInfo* out, const account::Uid& uid, ApplicationId appId) NN_NOEXCEPT;

    void DeleteDataTransferPolicy(ApplicationId appId) NN_NOEXCEPT;
    Result UpdateDataTransferPolicyAsync(AsyncRequest* out, ApplicationId appId) NN_NOEXCEPT;

    void RunAutonomyUploadTransferTaskRegistration(const account::Uid& uid) NN_NOEXCEPT;
}} // namespace nn::olsc
