﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

namespace nn { namespace oe {

//! @name HOME ボタンのブロック
//! @{

/**
    @brief 長押しを含む HOME ボタンのブロックを開始します。

    @details
     本関数を呼んでから EndBlockingHomeButton() を呼ぶまでの間、
     HOME ボタンが押されても HOME メニューへ移行しないようにします。

     HOME ボタンの長押しによるクイック設定への移行も行われません。
*/
void BeginBlockingHomeButton() NN_NOEXCEPT;

/**
    @brief 長押しを含む HOME ボタンのブロックを終了します。

    @details
     BeginBlockingHomeButton() で設定された HOME ボタンのブロックを終了し、
     通常通り HOME ボタンが押されたら HOME メニューに移行したり、
     HOME ボタンが長押しされたらクイック設定を表示するようにします。

    @see BeginBlockingHomeButton()
*/
void EndBlockingHomeButton() NN_NOEXCEPT;

//! @}

}}
