﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   常時動画撮影機能に関する API の宣言
 *
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_MemoryHeapCommon.h>

namespace nn { namespace oe {

//-----------------------------------------------------------------------------

//! @name   常時動画撮影機能に関する API
//! @{

/**
 * @brief   常時動画撮影機能に必要となるワークバッファサイズを表す定数です。
 *
 * @details
 *  プログラムの常時動画撮影機能を有効にするためには、
 *  この定数で示されるサイズのワークバッファ領域用のメモリを確保し、
 *  nn::oe::EnableGamePlayRecording() にそのバッファ領域を渡して下さい。
 *
 */
const size_t WorkBufferSizeForGamePlayRecording = 96u * 1024 * 1024;

//-----------------------------------------------------------------------------
/**
 * @deprecated  常時動画撮影機能を有効にします。
 *
 * @details
 *  この API は使用禁止となりました。将来的に削除される予定です。
 *
 *  動画撮影を有効にするには、アプリケーション管理データの
 *  \<VideoCapture\> で Enable を指定するようにして下さい。
 *
 *  アプリケーション管理データの設定については、
 *  confluencelink{166503043, 「nmeta ファイルの書き方 」} を参照してください。
 *
 */
NN_DEPRECATED void EnableGamePlayRecording(void* buffer, size_t size) NN_NOEXCEPT;


//-----------------------------------------------------------------------------
/**
 * @deprecated  常時動画撮影の録画を再開します。
 *
 * @details
 *  nn::oe::EnableRecording() を使用して下さい。
 *
 */
NN_DEPRECATED void RestartGamePlayRecording() NN_NOEXCEPT;


//-----------------------------------------------------------------------------
/**
 * @deprecated  常時動画撮影の録画を一時停止します。
 *
 * @details
 *  nn::oe::DisableRecording() を使用して下さい。
 *
 */
NN_DEPRECATED void PauseGamePlayRecording() NN_NOEXCEPT;


//! @}

//-----------------------------------------------------------------------------

}} // namespace nn::oe

