﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ntc/detail/service/ntc_Common.h>

namespace nn { namespace ntc { namespace detail { namespace service {

/**
 * @brief   サーバー時刻のダウンローダー
 * @details
 *  - 時刻の設定など、永続化データの書き込み・読み込みは一切行いません
 *  - 各 API はスレッドアンセーフです
 */
class ServerTimeDownloader
{
    NN_DISALLOW_COPY(ServerTimeDownloader);
    NN_DISALLOW_MOVE(ServerTimeDownloader);

public:

    //!< サーバーから時刻を取得する必要があるかどうか

    static bool IsDownloadRequired() NN_NOEXCEPT
    {
        // ネットワーク時計取得できなかったら補正する
        nn::time::PosixTime currentPosix;
        if(nn::time::StandardNetworkSystemClock::GetCurrentTime(&currentPosix).IsFailure())
        {
            return true;
        }
        NN_DETAIL_NTC_SERVER_LOG("Network time download is not required. Clock has been already corrected.\n");
        return false;
    }

    //!< サーバーから時刻取得して PosixTime を抽出.(ブロック関数)
    static nn::Result DownloadPosixTimeFromServer(
        nn::time::PosixTime* pOut) NN_NOEXCEPT;
};

}}}} // nn::ntc::detail::service
