﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

namespace nn { namespace ntc { namespace detail { namespace service {

//!< ネットワーク時計の自動補正処理自体を行うかどうか
const bool IsAutonomicCorrectionEnabled() NN_NOEXCEPT;

//!< EnsureNetworkClockAvailabilityMode_Default において、最後の補正からどれだけ経過していれば時刻ダウンロードするか
const nn::TimeSpan GetAutonomicCorrectionIntervalTimeSpan() NN_NOEXCEPT;

//!< 自立補正処理の失敗時にリトライするまでの間隔
const nn::TimeSpan GetAutonomicCorrectionRetryTimeSpan() NN_NOEXCEPT;

//!< ネットワーク接続を維持したまま自立補正処理を試行する最大回数
const int GetAutonomicCorrectionImmediateTryCountMax() NN_NOEXCEPT;

//!< ネットワーク接続を維持したまま自立補正処理を試行する間隔
const nn::TimeSpan GetAutonomicCorrectionImmediateTryTimeSpan() NN_NOEXCEPT;

}}}} // nn::ntc::detail::service
