﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief nn::nsd のバージョン定義
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace nsd {

    /**
     * @brief   ライブラリのバージョン
     * @details
     *  nn::nsd ライブラリが、インポートする設定ファイルに要求するバージョン番号です。@n
     *  以下の場合、FQDN 解決や NAS FQDN/設定の取得が失敗します。
     *
     *  - インポートされた設定ファイルのバージョン < nn::nsd::Version
     *
     *  例外として、Sirius 自体の FQDN やインターネット接続テストの FQDN は、必ず FQDN 解決が成功します。
     */
    const uint32_t Version = 2;

}} // nn::nsd
