﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nsd/nsd_Common.h>
#include <nn/nsd/nsd_TypesPrivate.h>
#include <nn/nsd/nsd_DeleteMode.h>

//
// ファイルシステム扱うものをここへ集める
//

namespace nn { namespace nsd { namespace detail { namespace fs {

    /**
     * @brief   デバイスへ設定を保存
     */
    nn::Result WriteSaveData(const SaveData& in) NN_NOEXCEPT;

    /**
     * @brief   デバイスへ設定の expireUnixTime 部分のみを保存
     */
    nn::Result WriteExpireUnixTime(const SaveData& in) NN_NOEXCEPT;

   /**
     * @brief   デバイスへ設定の isAvailable 部分のみを保存
     */
    nn::Result WriteIsAvailable(const SaveData& in) NN_NOEXCEPT;

    /**
     * @brief   アプリケーション向け設定を 0 で埋める
     */
    nn::Result FillEmptyApplicationSetting() NN_NOEXCEPT;

    /**
     * @brief   デバイスから設定の読み込み
     */
    nn::Result ReadSaveData(SaveData* pOut) NN_NOEXCEPT;

    /**
     * @brief   デバイスから設定名を取得
     * @details セーブデータの設定名の部分だけを読み込みます。
     */
    // 直接 fs 叩かずに FqdnResolver のキャッシュを返すように変更.いったんこの API を消す.
    // nn::Result GetSettingName(SettingName* pOut) NN_NOEXCEPT;

    /**
     * @brief   デバイスから環境識別子を取得
     * @details セーブデータの環境識別子の部分だけを読み込みます。
     */
    nn::Result GetEnvironmentIdentifier(EnvironmentIdentifier* pOut) NN_NOEXCEPT;

    /**
     * @brief   デバイスから設定を削除
     * @details データファイル自体を削除します。
     */
    nn::Result DeleteSaveData() NN_NOEXCEPT;

    /**
     * @brief   nn::fs:: で発生したエラーをダンプします（調査用）
     * @details 内部で発生した最初の fs エラーを NN_DETAIL_NSD_ERROR を使って出力します。
     */
    void DumpFirstFsErrorIfFailed() NN_NOEXCEPT;

}}}} // nn::nsd::detail::fs
