﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ProgramLocation.h>
#include <nn/ns/srv/ns_Event.h>
#include <nn/os/os_Event.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_Types.h>
#include <nn/pm/pm_ShellApi.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/util/util_Optional.h>
#include <nn/ns/ns_ApplicationControlDataApi.h>

namespace nn { namespace ns { namespace srv {

    void StartLaunchControl() NN_NOEXCEPT;

    Result LaunchProgram(os::ProcessId* pOut, const ncm::ProgramLocation& location, std::int32_t flags) NN_NOEXCEPT;
    Result TerminateProcess(os::ProcessId id) NN_NOEXCEPT;
    Result TerminateProgram(ncm::ProgramId id) NN_NOEXCEPT;
    Result TerminateApplication() NN_NOEXCEPT;
    util::optional<os::ProcessId> GetRunningApplicationProcessId() NN_NOEXCEPT;

    class IShellEventObserver
    {
    public:
        virtual void Notify(const pm::ProcessEventInfo& info) NN_NOEXCEPT = 0;
    };

    class ShellEventObserverHolder : public util::IntrusiveListBaseNode <ShellEventObserverHolder>
    {
    public:
        explicit ShellEventObserverHolder(IShellEventObserver* observer) : m_Observer(observer) {}

        void Notify(const pm::ProcessEventInfo& info)
        {
            m_Observer->Notify(info);
        }

    private:
        IShellEventObserver* m_Observer;
    };

    void RegisterShellEventObserver(ShellEventObserverHolder* holder) NN_NOEXCEPT;
    void UnregisterShellEventObserver(ShellEventObserverHolder* holder) NN_NOEXCEPT;

    void EnableApplicationCrashReport(bool isEnabled) NN_NOEXCEPT;
    bool IsApplicationCrashReportEnabled() NN_NOEXCEPT;
    void RegisterApplicationCrashReportPolicy(ns::CrashReport policy) NN_NOEXCEPT;
    void EnableApplicationAllThreadDumpOnCrash(bool isEnabled) NN_NOEXCEPT;

}}}  // namespace ns::srv

