﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/fs/fs_SystemSaveData.h>
#include <nn/kvdb/kvdb_BoundedString.h>
#include <nn/util/util_UuidTypes.h>

namespace nn { namespace ns { namespace srv {
    typedef util::Uuid MarkData;

    class MarkFile
    {
    public:
        MarkFile()
            : MarkFileName("private")
        {
        }

        void Initialize(const char* markDirectory) NN_NOEXCEPT;
        Result HasMarkFile(bool* outValue) NN_NOEXCEPT;
        Result GenerateMarkFile(const void* pExternalData, size_t externalDataSize) NN_NOEXCEPT;
        Result GenerateMarkFile(const MarkData* pData, const void* pExternalData, size_t externalDataSize) NN_NOEXCEPT;
        Result DeleteMarkFile() NN_NOEXCEPT;
        Result ReadMarkData(MarkData* outValue) const NN_NOEXCEPT;
        Result ReadExternalData(void* outBuffer, size_t size) const NN_NOEXCEPT;
        Result WriteMarkData(const MarkData* pData) NN_NOEXCEPT;
        Result WriteExternalData(const void* pData, size_t size) NN_NOEXCEPT;
        Result GetExternalDataSize(size_t* outValue) const NN_NOEXCEPT;
        const char* GetMarkFilePath() const NN_NOEXCEPT;

    private:
        // TORIAEZU: constexpr が VS2013 では使えないので、暫定対応
        static const int MaxPathLength = 48;
        const char* MarkFileName;
        typedef kvdb::BoundedString<MarkFile::MaxPathLength> Path;
        Path m_MarkFileDirectory;
        Path m_MarkFilePath;

        Result GenerateDirectoryImpl(const char* path) NN_NOEXCEPT;
        Result GenerateDirectory() NN_NOEXCEPT;
    };
}}}
