﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ns/srv/ns_Event.h>
#include <nn/os/os_MultipleWait.h>

namespace nn { namespace ns { namespace srv {

    class IEventHandler
    {
    public:
        virtual void HandleEvent() = 0;

        IEventHandler()
        {
            os::SetMultiWaitHolderUserData(m_Event.GetWaitHolder(), reinterpret_cast<uintptr_t>(this));
        }

        Event* GetEvent()
        {
            return &m_Event;
        }

    private:
         Event m_Event;
    };

}}}  // namespace nn::ns::srv

