﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/ns_ApplicationRightsTypes.h>
#include <nn/ns/detail/ns_IAsync.sfdl.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/account/account_Types.h>

namespace nn { namespace ns { namespace srv {

    class ApplicationRecordDatabase;
    class IntegratedContentManager;
    class RequestServer;
    class RightsEnvironmentManager;

    class DynamicRightsManager
    {
    public:
        DynamicRightsManager(
            ApplicationRecordDatabase* pDb, IntegratedContentManager* pIntegrated,
            RequestServer* pRequestServer, RightsEnvironmentManager* pRightsManager) NN_NOEXCEPT;

        Result RequestApplicationRightsOnServer(
            sf::Out<sf::NativeHandle> outHandle,
            sf::Out<sf::SharedPointer<ns::detail::IAsyncValue>> outAsync,
            ncm::ApplicationId id,
            const account::Uid& uid,
            Bit32 flags) NN_NOEXCEPT;

        Result RequestAssignRights(
            sf::Out<sf::NativeHandle> outHandle,
            sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync,
            sf::InArray<ApplicationRightsOnServer> list) NN_NOEXCEPT;

        Result RegisterUserOfAccountRestrictedRights(const account::Uid& uid) NN_NOEXCEPT;

        void UnregisterAllUsersOfAccountRestrictedRights() NN_NOEXCEPT;

        Result RequestAssignRightsToResume(
            sf::Out<sf::NativeHandle> outHandle,
            sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync,
            RightsEnvironmentHandle handle,
            const account::Uid& uid) NN_NOEXCEPT;

        Result VerifyActivatedRightsOwners(RightsEnvironmentHandle handle) NN_NOEXCEPT;

    private:
        ApplicationRecordDatabase* m_pRecordDb;
        IntegratedContentManager* m_pIntegrated;
        RequestServer* m_pRequestServer;
        RightsEnvironmentManager* m_pRightsEnvironmentManager;
    };
}}}
