﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/ncm/ncm_ContentMetaId.h>

namespace nn { namespace ns { namespace srv {

    struct BlackListRecord
    {
        Bit32       idLow;
        Bit32       idHigh;
        uint32_t    version;

        NN_FORCEINLINE const Bit64 ToValue64() const NN_NOEXCEPT;
        NN_FORCEINLINE ncm::ApplicationId ToApplicationId() const NN_NOEXCEPT;
    };
    NN_STATIC_ASSERT(sizeof(BlackListRecord) == 12);

    struct BlackListData
    {
        static const int RecordCountMax = 32;

        uint32_t        count;
        BlackListRecord records[RecordCountMax];
    };
    NN_STATIC_ASSERT(sizeof(BlackListData) == 388);

    class BlackListReader
    {
        NN_DISALLOW_COPY(BlackListReader);

    public:
        BlackListReader() NN_NOEXCEPT;
        ~BlackListReader() NN_NOEXCEPT;

        void Mount() NN_NOEXCEPT;
        void Unmount() NN_NOEXCEPT;

        void Read(BlackListData* buffer) NN_NOEXCEPT;

    private:
        bool m_IsMounted;
        std::unique_ptr<Bit8[]> m_MountCache;

        Result ReadAll(size_t* readSize, void* readBuffer, size_t bufferSize, const char* filePath) NN_NOEXCEPT;
    };

}}} // ~namespace nn::ns::srv

// 実装 ------------------------------------------------------------------------------------------
namespace nn { namespace ns { namespace srv {

NN_FORCEINLINE const Bit64 BlackListRecord::ToValue64() const NN_NOEXCEPT
{
    return (static_cast<Bit64>(idHigh) << 32) | idLow;
}

NN_FORCEINLINE ncm::ApplicationId BlackListRecord::ToApplicationId() const NN_NOEXCEPT
{
    return ncm::ApplicationId{ToValue64()};
}

}}} // ~namespace nn::ns::srv
