﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/ns_ApplicationViewApi.h>
#include <nn/ns/ns_RetailInteractiveDisplayApi.h>
#include <nn/ns/srv/ns_ApplicationRecordDatabase.h>
#include <nn/ns/srv/ns_ApplicationEntityManager.h>
#include <nn/ns/srv/ns_ApplicationEntityViewCache.h>
#include <nn/ns/srv/ns_CommitManager.h>
#include <nn/ns/srv/ns_IntegratedContentManager.h>
#include <nn/ns/srv/ns_LockedBufferManager.h>
#include <nn/ns/srv/ns_RequestServer.h>
#include <nn/ns/srv/ns_SystemReportManager.h>

namespace nn { namespace ns { namespace srv {
    // ライブラリ側で宣言していたので、ひとまずこれで
    class ApplicationInstallTask;

    class ApplicationViewManager
    {
    public:
        void Initialize(ApplicationRecordDatabase* record, ApplicationEntityManager* entityManager, IntegratedContentManager* integrated, RequestServer* requestServer, SystemReportManager* reportManager, CommitManager* commitManager, LockedBufferManager* lockedBufferManager) NN_NOEXCEPT;
        Result GetApplicationViewDeprecated(const sf::OutArray<ns::ApplicationViewDeprecated>& outList, const sf::InArray<ncm::ApplicationId>& idList) NN_NOEXCEPT;
        Result GetApplicationView(const sf::OutArray<ns::ApplicationView>& outList, const sf::InArray<ncm::ApplicationId>& idList) NN_NOEXCEPT;
        Result GetApplicationViewDownloadErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        Result ListApplicationDownloadingContentMeta(sf::Out<std::int32_t> outCount, const sf::OutArray<ncm::StorageContentMetaKey>& outList, ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT;
        Result GetApplicationDownloadTaskStatus(sf::Out<ApplicationDownloadTaskStatus> outValue, ncm::ApplicationId id);
        void InvalidateCache() NN_NOEXCEPT;
    private:
        Result GetApplicationViewOne(ns::ApplicationView* outValue, ncm::ApplicationId id) NN_NOEXCEPT;
        Result GetApplicationEntityView(ns::ApplicationRecord* outRecord, ns::ApplicationView* outView, ncm::ApplicationId id) NN_NOEXCEPT;

        Result CommitDownloadTaskIfNeeded(ncm::ApplicationId id) NN_NOEXCEPT;
        Result CommitApplyDeltaTaskIfNeeded(ncm::ApplicationId id) NN_NOEXCEPT;

        Result UpdateViewFromDownloadTask(ns::ApplicationView* view, ncm::ApplicationId id) NN_NOEXCEPT;
        Result UpdateViewFromApplyDeltaTask(ns::ApplicationView* view, ncm::ApplicationId id) NN_NOEXCEPT;

        Result ReportThroughput(ApplicationInstallTask* task, ncm::ApplicationId applicationId, ncm::StorageContentMetaKey* keys, int count) NN_NOEXCEPT;

        ApplicationRecordDatabase* m_RecordDb;
        ApplicationEntityManager*  m_EntityManager;
        IntegratedContentManager*  m_Integrated;
        RequestServer*             m_RequestServer;
        SystemReportManager*       m_SystemReportManager;
        CommitManager*             m_CommitManager;
        LockedBufferManager*       m_LockedBufferManager;

        ApplicationEntityViewCacheHolder m_EntityViewCache;
    };
}}}
