﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/srv/ns_IntegratedContentManager.h>
#include <nn/ns/srv/ns_ApplicationRecordDatabase.h>
#include <nn/ns/srv/ns_RequestServer.h>
#include <nn/ns/srv/ns_TicketManager.h>
#include <nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>

namespace nn { namespace ns { namespace srv {
    class ApplicationVerificationManager
    {
    public:
        ApplicationVerificationManager() NN_NOEXCEPT
            : m_pContentManager(nullptr)
            , m_pRecordDb(nullptr)
            , m_pRequestServer(nullptr)
        {
        }

        Result Initialize(IntegratedContentManager* p_ContentManager, ApplicationRecordDatabase* pRecordDb, RequestServer* pRequestServer, TicketManager* pTicketManager) NN_NOEXCEPT;

        Result RequestVerifyApplication(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IProgressAsyncResult>> outAsync, ncm::ApplicationId appId, Bit32 flags, sf::NativeHandle transferHandle, uint64_t transferSize) NN_NOEXCEPT;
        Result CorruptApplicationForDebug(ncm::ApplicationId id, Bit32 flags, ncm::StorageId storageId) NN_NOEXCEPT;
        Result CorruptContentForDebug(const ncm::ContentMetaKey& key, ncm::StorageId storageId) NN_NOEXCEPT;
        Result RequestVerifyAddOnContentsRights(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IProgressAsyncResult>> outAsync, ncm::ApplicationId id) NN_NOEXCEPT;

    private:
        IntegratedContentManager* m_pContentManager;
        ApplicationRecordDatabase* m_pRecordDb;
        RequestServer* m_pRequestServer;
        TicketManager* m_pTicketManager;
    };
}}}
